/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.logserver.net.control;

import com.yahoo.logserver.net.control.State;
import java.util.LinkedHashMap;
import java.util.Map;

public class Levels
implements Cloneable {
    private final Map<String, State> levelsMap = new LinkedHashMap<String, State>(10);

    public Levels() {
        this.levelsMap.put("event", State.FORWARD);
        this.levelsMap.put("fatal", State.FORWARD);
        this.levelsMap.put("error", State.FORWARD);
        this.levelsMap.put("warning", State.FORWARD);
        this.levelsMap.put("info", State.FORWARD);
        this.levelsMap.put("config", State.FORWARD);
        this.levelsMap.put("debug", State.NOFORWARD);
        this.levelsMap.put("spam", State.NOFORWARD);
    }

    public static Levels parse(String levels) {
        return new Levels().updateLevels(levels);
    }

    public Levels updateLevels(String levels) {
        String[] parts = levels.split(",");
        if (parts.length < 1) {
            return this;
        }
        for (int i = 0; i < parts.length; ++i) {
            String pair = parts[i];
            int offset = pair.indexOf(61);
            if (offset == -1) continue;
            String name = pair.substring(0, offset).trim().toLowerCase();
            String value = pair.substring(offset + 1).trim().toLowerCase();
            this.setLevelState(name, State.parse(value));
        }
        return this;
    }

    public Levels setLevelState(String level, State state) {
        this.levelsMap.put(level, state);
        return this;
    }

    public State getLevelState(String level) {
        State s = this.levelsMap.get(level);
        if (s == null) {
            return State.UNKNOWN;
        }
        return s;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder(80);
        boolean first = true;
        for (Map.Entry<String, State> me : this.levelsMap.entrySet()) {
            if (!first) {
                sbuf.append(',');
            } else {
                first = false;
            }
            sbuf.append(me.getKey()).append('=').append(me.getValue());
        }
        return sbuf.toString();
    }

    public Object clone() {
        return Levels.parse(this.toString());
    }
}

