/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config.log;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class LogdConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "d990b8d5b58421a1bd40bcba0079621c";
    public static final String CONFIG_DEF_NAME = "logd";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config.log";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config.log", "stateport int default=0", "logserver.host string default=\"localhost\"", "logserver.rpcport int default=5822", "logserver.use bool default=true", "loglevel.fatal.forward bool default=true", "loglevel.error.forward bool default=true", "loglevel.warning.forward bool default=true", "loglevel.config.forward bool default=true", "loglevel.info.forward bool default=true", "loglevel.event.forward bool default=true", "loglevel.debug.forward bool default=false", "loglevel.spam.forward bool default=false", "rotate.size int default=10000000", "rotate.age int default=86400", "remove.totalmegabytes int default=1000", "remove.age int default=30"};
    private final IntegerNode stateport;
    private final Logserver logserver;
    private final Loglevel loglevel;
    private final Rotate rotate;
    private final Remove remove;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LogdConfig(Builder builder) {
        this(builder, true);
    }

    private LogdConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for logd must be initialized: " + builder.__uninitialized);
        }
        this.stateport = builder.stateport == null ? new IntegerNode(0) : new IntegerNode(builder.stateport.intValue());
        this.logserver = new Logserver(builder.logserver, throwIfUninitialized);
        this.loglevel = new Loglevel(builder.loglevel, throwIfUninitialized);
        this.rotate = new Rotate(builder.rotate, throwIfUninitialized);
        this.remove = new Remove(builder.remove, throwIfUninitialized);
    }

    public int stateport() {
        return this.stateport.value();
    }

    public Logserver logserver() {
        return this.logserver;
    }

    public Loglevel loglevel() {
        return this.loglevel;
    }

    public Rotate rotate() {
        return this.rotate;
    }

    public Remove remove() {
        return this.remove;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LogdConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer stateport = null;
        public Logserver.Builder logserver = new Logserver.Builder();
        public Loglevel.Builder loglevel = new Loglevel.Builder();
        public Rotate.Builder rotate = new Rotate.Builder();
        public Remove.Builder remove = new Remove.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LogdConfig config) {
            this.stateport(config.stateport());
            this.logserver(new Logserver.Builder(config.logserver()));
            this.loglevel(new Loglevel.Builder(config.loglevel()));
            this.rotate(new Rotate.Builder(config.rotate()));
            this.remove(new Remove.Builder(config.remove()));
        }

        private Builder override(Builder __superior) {
            if (__superior.stateport != null) {
                this.stateport(__superior.stateport);
            }
            this.logserver(this.logserver.override(__superior.logserver));
            this.loglevel(this.loglevel.override(__superior.loglevel));
            this.rotate(this.rotate.override(__superior.rotate));
            this.remove(this.remove.override(__superior.remove));
            return this;
        }

        public Builder stateport(int __value) {
            this.stateport = __value;
            return this;
        }

        private Builder stateport(String __value) {
            return this.stateport(Integer.valueOf(__value));
        }

        public Builder logserver(Logserver.Builder __builder) {
            this.logserver = __builder;
            return this;
        }

        public Builder logserver(Consumer<Logserver.Builder> __func) {
            Logserver.Builder __inner = new Logserver.Builder();
            __func.accept(__inner);
            this.logserver = __inner;
            return this;
        }

        public Builder loglevel(Loglevel.Builder __builder) {
            this.loglevel = __builder;
            return this;
        }

        public Builder loglevel(Consumer<Loglevel.Builder> __func) {
            Loglevel.Builder __inner = new Loglevel.Builder();
            __func.accept(__inner);
            this.loglevel = __inner;
            return this;
        }

        public Builder rotate(Rotate.Builder __builder) {
            this.rotate = __builder;
            return this;
        }

        public Builder rotate(Consumer<Rotate.Builder> __func) {
            Rotate.Builder __inner = new Rotate.Builder();
            __func.accept(__inner);
            this.rotate = __inner;
            return this;
        }

        public Builder remove(Remove.Builder __builder) {
            this.remove = __builder;
            return this;
        }

        public Builder remove(Consumer<Remove.Builder> __func) {
            Remove.Builder __inner = new Remove.Builder();
            __func.accept(__inner);
            this.remove = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LogdConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LogdConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LogdConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LogdConfig build() {
            return new LogdConfig(this);
        }
    }

    public static final class Logserver
    extends InnerNode {
        private final StringNode host;
        private final IntegerNode rpcport;
        private final BooleanNode use;

        public Logserver(Builder builder) {
            this(builder, true);
        }

        private Logserver(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for logd.logserver must be initialized: " + builder.__uninitialized);
            }
            this.host = builder.host == null ? new StringNode("localhost") : new StringNode(builder.host);
            this.rpcport = builder.rpcport == null ? new IntegerNode(5822) : new IntegerNode(builder.rpcport.intValue());
            this.use = builder.use == null ? new BooleanNode(true) : new BooleanNode(builder.use.booleanValue());
        }

        public String host() {
            return this.host.value();
        }

        public int rpcport() {
            return this.rpcport.value();
        }

        public boolean use() {
            return this.use.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Logserver newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("logserver");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String host = null;
            private Integer rpcport = null;
            private Boolean use = null;

            public Builder() {
            }

            public Builder(Logserver config) {
                this.host(config.host());
                this.rpcport(config.rpcport());
                this.use(config.use());
            }

            private Builder override(Builder __superior) {
                if (__superior.host != null) {
                    this.host(__superior.host);
                }
                if (__superior.rpcport != null) {
                    this.rpcport(__superior.rpcport);
                }
                if (__superior.use != null) {
                    this.use(__superior.use);
                }
                return this;
            }

            public Builder host(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.host = __value;
                return this;
            }

            public Builder rpcport(int __value) {
                this.rpcport = __value;
                return this;
            }

            private Builder rpcport(String __value) {
                return this.rpcport(Integer.valueOf(__value));
            }

            public Builder use(boolean __value) {
                this.use = __value;
                return this;
            }

            private Builder use(String __value) {
                return this.use(Boolean.valueOf(__value));
            }

            public Logserver build() {
                return new Logserver(this);
            }
        }
    }

    public static final class Loglevel
    extends InnerNode {
        private final Fatal fatal;
        private final Error error;
        private final Warning warning;
        private final Config config;
        private final Info info;
        private final Event event;
        private final Debug debug;
        private final Spam spam;

        public Loglevel(Builder builder) {
            this(builder, true);
        }

        private Loglevel(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for logd.loglevel must be initialized: " + builder.__uninitialized);
            }
            this.fatal = new Fatal(builder.fatal, throwIfUninitialized);
            this.error = new Error(builder.error, throwIfUninitialized);
            this.warning = new Warning(builder.warning, throwIfUninitialized);
            this.config = new Config(builder.config, throwIfUninitialized);
            this.info = new Info(builder.info, throwIfUninitialized);
            this.event = new Event(builder.event, throwIfUninitialized);
            this.debug = new Debug(builder.debug, throwIfUninitialized);
            this.spam = new Spam(builder.spam, throwIfUninitialized);
        }

        public Fatal fatal() {
            return this.fatal;
        }

        public Error error() {
            return this.error;
        }

        public Warning warning() {
            return this.warning;
        }

        public Config config() {
            return this.config;
        }

        public Info info() {
            return this.info;
        }

        public Event event() {
            return this.event;
        }

        public Debug debug() {
            return this.debug;
        }

        public Spam spam() {
            return this.spam;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Loglevel newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("loglevel");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Fatal.Builder fatal = new Fatal.Builder();
            public Error.Builder error = new Error.Builder();
            public Warning.Builder warning = new Warning.Builder();
            public Config.Builder config = new Config.Builder();
            public Info.Builder info = new Info.Builder();
            public Event.Builder event = new Event.Builder();
            public Debug.Builder debug = new Debug.Builder();
            public Spam.Builder spam = new Spam.Builder();

            public Builder() {
            }

            public Builder(Loglevel config) {
                this.fatal(new Fatal.Builder(config.fatal()));
                this.error(new Error.Builder(config.error()));
                this.warning(new Warning.Builder(config.warning()));
                this.config(new Config.Builder(config.config()));
                this.info(new Info.Builder(config.info()));
                this.event(new Event.Builder(config.event()));
                this.debug(new Debug.Builder(config.debug()));
                this.spam(new Spam.Builder(config.spam()));
            }

            private Builder override(Builder __superior) {
                this.fatal(this.fatal.override(__superior.fatal));
                this.error(this.error.override(__superior.error));
                this.warning(this.warning.override(__superior.warning));
                this.config(this.config.override(__superior.config));
                this.info(this.info.override(__superior.info));
                this.event(this.event.override(__superior.event));
                this.debug(this.debug.override(__superior.debug));
                this.spam(this.spam.override(__superior.spam));
                return this;
            }

            public Builder fatal(Fatal.Builder __builder) {
                this.fatal = __builder;
                return this;
            }

            public Builder fatal(Consumer<Fatal.Builder> __func) {
                Fatal.Builder __inner = new Fatal.Builder();
                __func.accept(__inner);
                this.fatal = __inner;
                return this;
            }

            public Builder error(Error.Builder __builder) {
                this.error = __builder;
                return this;
            }

            public Builder error(Consumer<Error.Builder> __func) {
                Error.Builder __inner = new Error.Builder();
                __func.accept(__inner);
                this.error = __inner;
                return this;
            }

            public Builder warning(Warning.Builder __builder) {
                this.warning = __builder;
                return this;
            }

            public Builder warning(Consumer<Warning.Builder> __func) {
                Warning.Builder __inner = new Warning.Builder();
                __func.accept(__inner);
                this.warning = __inner;
                return this;
            }

            public Builder config(Config.Builder __builder) {
                this.config = __builder;
                return this;
            }

            public Builder config(Consumer<Config.Builder> __func) {
                Config.Builder __inner = new Config.Builder();
                __func.accept(__inner);
                this.config = __inner;
                return this;
            }

            public Builder info(Info.Builder __builder) {
                this.info = __builder;
                return this;
            }

            public Builder info(Consumer<Info.Builder> __func) {
                Info.Builder __inner = new Info.Builder();
                __func.accept(__inner);
                this.info = __inner;
                return this;
            }

            public Builder event(Event.Builder __builder) {
                this.event = __builder;
                return this;
            }

            public Builder event(Consumer<Event.Builder> __func) {
                Event.Builder __inner = new Event.Builder();
                __func.accept(__inner);
                this.event = __inner;
                return this;
            }

            public Builder debug(Debug.Builder __builder) {
                this.debug = __builder;
                return this;
            }

            public Builder debug(Consumer<Debug.Builder> __func) {
                Debug.Builder __inner = new Debug.Builder();
                __func.accept(__inner);
                this.debug = __inner;
                return this;
            }

            public Builder spam(Spam.Builder __builder) {
                this.spam = __builder;
                return this;
            }

            public Builder spam(Consumer<Spam.Builder> __func) {
                Spam.Builder __inner = new Spam.Builder();
                __func.accept(__inner);
                this.spam = __inner;
                return this;
            }

            public Loglevel build() {
                return new Loglevel(this);
            }
        }

        public static final class Fatal
        extends InnerNode {
            private final BooleanNode forward;

            public Fatal(Builder builder) {
                this(builder, true);
            }

            private Fatal(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.fatal must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(true) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Fatal newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("fatal");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Fatal config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Fatal build() {
                    return new Fatal(this);
                }
            }
        }

        public static final class Error
        extends InnerNode {
            private final BooleanNode forward;

            public Error(Builder builder) {
                this(builder, true);
            }

            private Error(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.error must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(true) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Error newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("error");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Error config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Error build() {
                    return new Error(this);
                }
            }
        }

        public static final class Warning
        extends InnerNode {
            private final BooleanNode forward;

            public Warning(Builder builder) {
                this(builder, true);
            }

            private Warning(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.warning must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(true) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Warning newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("warning");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Warning config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Warning build() {
                    return new Warning(this);
                }
            }
        }

        public static final class Config
        extends InnerNode {
            private final BooleanNode forward;

            public Config(Builder builder) {
                this(builder, true);
            }

            private Config(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.config must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(true) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Config newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("config");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Config config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Config build() {
                    return new Config(this);
                }
            }
        }

        public static final class Info
        extends InnerNode {
            private final BooleanNode forward;

            public Info(Builder builder) {
                this(builder, true);
            }

            private Info(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.info must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(true) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Info newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("info");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Info config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Info build() {
                    return new Info(this);
                }
            }
        }

        public static final class Event
        extends InnerNode {
            private final BooleanNode forward;

            public Event(Builder builder) {
                this(builder, true);
            }

            private Event(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.event must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(true) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Event newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("event");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Event config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Event build() {
                    return new Event(this);
                }
            }
        }

        public static final class Debug
        extends InnerNode {
            private final BooleanNode forward;

            public Debug(Builder builder) {
                this(builder, true);
            }

            private Debug(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.debug must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(false) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Debug newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("debug");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Debug config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Debug build() {
                    return new Debug(this);
                }
            }
        }

        public static final class Spam
        extends InnerNode {
            private final BooleanNode forward;

            public Spam(Builder builder) {
                this(builder, true);
            }

            private Spam(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for logd.loglevel.spam must be initialized: " + builder.__uninitialized);
                }
                this.forward = builder.forward == null ? new BooleanNode(false) : new BooleanNode(builder.forward.booleanValue());
            }

            public boolean forward() {
                return this.forward.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Spam newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("spam");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Boolean forward = null;

                public Builder() {
                }

                public Builder(Spam config) {
                    this.forward(config.forward());
                }

                private Builder override(Builder __superior) {
                    if (__superior.forward != null) {
                        this.forward(__superior.forward);
                    }
                    return this;
                }

                public Builder forward(boolean __value) {
                    this.forward = __value;
                    return this;
                }

                private Builder forward(String __value) {
                    return this.forward(Boolean.valueOf(__value));
                }

                public Spam build() {
                    return new Spam(this);
                }
            }
        }
    }

    public static final class Rotate
    extends InnerNode {
        private final IntegerNode size;
        private final IntegerNode age;

        public Rotate(Builder builder) {
            this(builder, true);
        }

        private Rotate(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for logd.rotate must be initialized: " + builder.__uninitialized);
            }
            this.size = builder.size == null ? new IntegerNode(10000000) : new IntegerNode(builder.size.intValue());
            this.age = builder.age == null ? new IntegerNode(86400) : new IntegerNode(builder.age.intValue());
        }

        public int size() {
            return this.size.value();
        }

        public int age() {
            return this.age.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rotate newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rotate");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer size = null;
            private Integer age = null;

            public Builder() {
            }

            public Builder(Rotate config) {
                this.size(config.size());
                this.age(config.age());
            }

            private Builder override(Builder __superior) {
                if (__superior.size != null) {
                    this.size(__superior.size);
                }
                if (__superior.age != null) {
                    this.age(__superior.age);
                }
                return this;
            }

            public Builder size(int __value) {
                this.size = __value;
                return this;
            }

            private Builder size(String __value) {
                return this.size(Integer.valueOf(__value));
            }

            public Builder age(int __value) {
                this.age = __value;
                return this;
            }

            private Builder age(String __value) {
                return this.age(Integer.valueOf(__value));
            }

            public Rotate build() {
                return new Rotate(this);
            }
        }
    }

    public static final class Remove
    extends InnerNode {
        private final IntegerNode totalmegabytes;
        private final IntegerNode age;

        public Remove(Builder builder) {
            this(builder, true);
        }

        private Remove(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for logd.remove must be initialized: " + builder.__uninitialized);
            }
            this.totalmegabytes = builder.totalmegabytes == null ? new IntegerNode(1000) : new IntegerNode(builder.totalmegabytes.intValue());
            this.age = builder.age == null ? new IntegerNode(30) : new IntegerNode(builder.age.intValue());
        }

        public int totalmegabytes() {
            return this.totalmegabytes.value();
        }

        public int age() {
            return this.age.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Remove newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("remove");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer totalmegabytes = null;
            private Integer age = null;

            public Builder() {
            }

            public Builder(Remove config) {
                this.totalmegabytes(config.totalmegabytes());
                this.age(config.age());
            }

            private Builder override(Builder __superior) {
                if (__superior.totalmegabytes != null) {
                    this.totalmegabytes(__superior.totalmegabytes);
                }
                if (__superior.age != null) {
                    this.age(__superior.age);
                }
                return this;
            }

            public Builder totalmegabytes(int __value) {
                this.totalmegabytes = __value;
                return this;
            }

            private Builder totalmegabytes(String __value) {
                return this.totalmegabytes(Integer.valueOf(__value));
            }

            public Builder age(int __value) {
                this.age = __value;
                return this;
            }

            private Builder age(String __value) {
                return this.age(Integer.valueOf(__value));
            }

            public Remove build() {
                return new Remove(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

