/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Packet;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Values;
import java.nio.ByteBuffer;

class RequestPacket
extends Packet {
    private StringValue methodName;
    private Values parameters;

    public RequestPacket(int flags, int reqId, String methodName, Values parameters) {
        super(flags, reqId);
        this.methodName = new StringValue(methodName);
        this.parameters = parameters;
    }

    public RequestPacket(int flags, int reqId, ByteBuffer src) {
        super(flags, reqId);
        this.methodName = new StringValue(src);
        this.parameters = new Values(src);
    }

    @Override
    public int bytes() {
        return 12 + this.methodName.bytes() + this.parameters.bytes();
    }

    @Override
    public int packetCode() {
        return 100;
    }

    @Override
    public void encode(ByteBuffer dst) {
        this.methodName.encode(dst);
        this.parameters.encode(dst);
    }

    public String methodName() {
        return this.methodName.asString();
    }

    public Values parameters() {
        return this.parameters;
    }
}

