/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.EndOfQueueException;
import com.yahoo.jrt.Queue;

class ThreadQueue {
    private Queue queue = new Queue();
    private boolean closed = false;

    public boolean enqueue(Object obj) {
        return this.enqueue(obj, Integer.MAX_VALUE);
    }

    public synchronized boolean enqueue(Object obj, int limit) {
        if (this.closed || this.queue.size() > limit) {
            return false;
        }
        this.queue.enqueue(obj);
        if (this.queue.size() == 1) {
            this.notify();
        }
        return true;
    }

    public synchronized void close() {
        this.closed = true;
        this.notify();
    }

    public synchronized Object dequeue() throws EndOfQueueException {
        while (this.queue.isEmpty() && !this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.queue.isEmpty()) {
            throw new EndOfQueueException();
        }
        return this.queue.dequeue();
    }
}

