/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Int8Array
extends Value {
    private byte[] value;

    public Int8Array(byte[] value) {
        this.value = value;
    }

    Int8Array(ByteBuffer src) {
        int size = src.getInt();
        this.value = new byte[size];
        src.get(this.value);
    }

    @Override
    public byte type() {
        return 66;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        return 4 + this.value.length;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        dst.put(this.value);
    }

    @Override
    public byte[] asInt8Array() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }
}

