/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Spec {
    private SocketAddress address;
    private String host;
    private int port;
    private boolean malformed;

    public Spec(String spec) {
        if (spec.startsWith("tcp/")) {
            String portStr;
            int sep = spec.indexOf(58);
            if (sep == -1) {
                portStr = spec.substring(4);
            } else {
                this.host = spec.substring(4, sep);
                portStr = spec.substring(sep + 1);
            }
            try {
                this.port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                this.host = null;
                this.port = 0;
                this.malformed = true;
            }
        } else {
            this.malformed = true;
        }
    }

    public Spec(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Spec(int port) {
        this.port = port;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean malformed() {
        return this.malformed;
    }

    SocketAddress address() {
        if (this.malformed) {
            return null;
        }
        if (this.address == null) {
            this.address = this.host == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port);
        }
        return this.address;
    }

    public String toString() {
        if (this.malformed) {
            return "MALFORMED";
        }
        if (this.host == null) {
            return "tcp/" + this.port;
        }
        return "tcp/" + this.host + ":" + this.port;
    }
}

