/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Connection;
import com.yahoo.jrt.EndOfQueueException;
import com.yahoo.jrt.ThreadQueue;
import com.yahoo.jrt.Transport;

class Closer {
    private Thread thread = new Thread((Runnable)new Run(), "<closer>");
    private Transport parent;
    private ThreadQueue closeQueue = new ThreadQueue();

    public Closer(Transport parent) {
        this.parent = parent;
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void closeLater(Connection c) {
        if (!this.closeQueue.enqueue(c)) {
            c.closeSocket();
        }
    }

    private void run() {
        try {
            while (true) {
                ((Connection)this.closeQueue.dequeue()).closeSocket();
            }
        }
        catch (EndOfQueueException endOfQueueException) {
            return;
        }
    }

    public Closer shutdown() {
        this.closeQueue.close();
        return this;
    }

    public void join() {
        while (true) {
            try {
                this.thread.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private class Run
    implements Runnable {
        private Run() {
        }

        @Override
        public void run() {
            try {
                Closer.this.run();
            }
            catch (Throwable problem) {
                Closer.this.parent.handleFailure(problem, Closer.this);
            }
        }
    }
}

