/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.validation.PatternedStringWrapper;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AwsPath
extends PatternedStringWrapper<AwsPath> {
    private static final Pattern namePattern = Pattern.compile("/[/.a-zA-Z0-9_-]{0,173}");

    private AwsPath(String name) {
        super(name, namePattern, "AWS path");
    }

    public static AwsPath of(String ... elements) {
        if (elements != null && elements.length > 0 && elements[0] != null && !elements[0].isEmpty()) {
            return new AwsPath(Stream.of(elements).map(String::toLowerCase).collect(Collectors.joining("/", "/", "/")));
        }
        return new AwsPath("/");
    }

    public static AwsPath root() {
        return new AwsPath("/");
    }

    public static AwsPath fromAwsPathString(String path) {
        return new AwsPath(path);
    }
}

