/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.aws;

import ai.vespa.secret.aws.AwsRolePath;
import ai.vespa.secret.model.VaultName;
import com.yahoo.component.AbstractComponent;
import com.yahoo.vespa.athenz.api.AthenzDomain;
import com.yahoo.vespa.athenz.api.AwsTemporaryCredentials;
import com.yahoo.vespa.athenz.aws.AwsCredentials;
import com.yahoo.vespa.athenz.client.zts.ZtsClient;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public abstract class AsmSecretStoreBase
extends AbstractComponent
implements AutoCloseable {
    public static final String AWSCURRENT = "AWSCURRENT";
    private final Function<AwsRolePath, SecretsManagerClient> clientAndCredentialsSupplier;
    private final ConcurrentMap<AwsRolePath, SecretsManagerClient> clientMap = new ConcurrentHashMap<AwsRolePath, SecretsManagerClient>();

    public AsmSecretStoreBase(ZtsClient ztsClient, AthenzDomain athenzDomain) {
        this(awsRole -> (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.US_EAST_1)).credentialsProvider(AsmSecretStoreBase.getAwsSessionCredsProvider(awsRole, ztsClient, athenzDomain))).build());
    }

    protected AsmSecretStoreBase(Function<AwsRolePath, SecretsManagerClient> clientAndCredentialsSupplier) {
        this.clientAndCredentialsSupplier = clientAndCredentialsSupplier;
    }

    protected abstract AwsRolePath awsRole(VaultName var1);

    protected SecretsManagerClient getClient(VaultName vault) {
        AwsRolePath awsRole = this.awsRole(vault);
        this.clientMap.putIfAbsent(awsRole, this.clientAndCredentialsSupplier.apply(awsRole));
        return (SecretsManagerClient)this.clientMap.get(awsRole);
    }

    private static AwsCredentialsProvider getAwsSessionCredsProvider(AwsRolePath role, ZtsClient ztsClient, AthenzDomain athenzDomain) {
        AwsCredentials credentials = new AwsCredentials(ztsClient, athenzDomain, role.athenzAwsRole());
        return () -> {
            AwsTemporaryCredentials temporary = credentials.get();
            return AwsSessionCredentials.create((String)temporary.accessKeyId(), (String)temporary.secretAccessKey(), (String)temporary.sessionToken());
        };
    }

    @Override
    public void close() {
        this.clientMap.values().forEach(client -> {
            try {
                client.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to close", e);
            }
        });
    }

    public void deconstruct() {
        this.close();
        super.deconstruct();
    }

    public Set<AwsRolePath> clientRoleNames() {
        return new HashSet<AwsRolePath>(this.clientMap.keySet());
    }
}

