/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ChoiceExpression
extends ExpressionList<Expression> {
    public ChoiceExpression() {
        this(List.of());
    }

    public ChoiceExpression(Expression ... choices) {
        this(List.of(choices));
    }

    public ChoiceExpression(Collection<? extends Expression> choices) {
        super(choices, ChoiceExpression.resolveInputType(choices));
    }

    @Override
    public ChoiceExpression convertChildren(ExpressionConverter converter) {
        return new ChoiceExpression(this.asList().stream().map(choice -> converter.branch().convert((Expression)((Object)choice))).toList());
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        DataType resolvedType = null;
        boolean resolvedTypeNeverAssigned = true;
        for (Expression expression : this.expressions()) {
            DataType outputType = expression.setInputType(inputType, context);
            resolvedType = resolvedTypeNeverAssigned ? outputType : this.mostGeneralOf(resolvedType, outputType);
            resolvedTypeNeverAssigned = false;
        }
        return resolvedType != null ? resolvedType : this.getOutputType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(outputType, context);
        DataType resolvedType = null;
        boolean resolvedTypeNeverAssigned = true;
        for (Expression expression : this.expressions()) {
            DataType inputType = expression.setOutputType(outputType, context);
            resolvedType = resolvedTypeNeverAssigned ? inputType : this.mostGeneralOf(resolvedType, inputType);
            resolvedTypeNeverAssigned = false;
        }
        return resolvedType != null ? resolvedType : this.getInputType(context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getCurrentType();
        context.setCurrentType(input);
        for (Expression exp : this) {
            context.setCurrentType(input).verify(exp);
        }
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        for (Expression expression : this) {
            context.setCurrentValue(input).execute(expression);
            if (context.getCurrentValue() == null) continue;
            break;
        }
    }

    private static DataType resolveInputType(Collection<? extends Expression> list) {
        DataType previousInput = null;
        DataType previousOutput = null;
        for (Expression expression : list) {
            DataType thisInput = expression.requiredInputType();
            if (previousInput == null) {
                previousInput = thisInput;
            } else if (thisInput != null && !previousInput.isAssignableFrom(thisInput)) {
                throw new VerificationException(ScriptExpression.class, "Choice expression require conflicting input types, " + previousInput.getName() + " vs " + thisInput.getName());
            }
            DataType thisOutput = expression.createdOutputType();
            if (previousOutput == null) {
                previousOutput = thisOutput;
                continue;
            }
            if (thisOutput == null || previousOutput.isAssignableFrom(thisOutput)) continue;
            throw new VerificationException(ScriptExpression.class, "Choice expression produce conflicting output types, " + previousOutput.getName() + " vs " + thisOutput.getName());
        }
        return previousInput;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return this.asList().stream().map(Object::toString).collect(Collectors.joining(" || "));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof ChoiceExpression;
    }
}

