/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import com.yahoo.document.update.TensorAddUpdate;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.document.update.TensorRemoveUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespa.indexinglanguage.DocumentAdapter;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValueAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FieldUpdateAdapter
implements UpdateAdapter {
    private final DocumentAdapter adapter;
    private final Builder builder;
    private final Expression optimizedExpression;

    private FieldUpdateAdapter(Expression optimizedExpression, DocumentAdapter adapter, Builder builder) {
        this.adapter = adapter;
        this.builder = builder;
        this.optimizedExpression = optimizedExpression;
    }

    @Override
    public DocumentUpdate getOutput() {
        Document doc = this.adapter.getUpdatableOutput();
        DocumentUpdate upd = new DocumentUpdate(doc.getDataType(), doc.getId());
        for (Map.Entry entry : doc) {
            Field field = (Field)entry.getKey();
            if (field.getName().equals("sddocname")) continue;
            FieldUpdate fieldUpd = FieldUpdate.create((Field)field);
            fieldUpd.addValueUpdates(this.builder.build((FieldValue)entry.getValue()));
            if (fieldUpd.isEmpty()) continue;
            upd.addFieldUpdate(fieldUpd);
        }
        return upd.isEmpty() ? null : upd;
    }

    @Override
    public Expression getExpression(Expression expression) {
        return this.optimizedExpression != null ? this.optimizedExpression : expression;
    }

    @Override
    public DataType getInputType(Expression exp, String fieldName) {
        return this.adapter.getInputType(exp, fieldName);
    }

    @Override
    public FieldValue getInputValue(String fieldName) {
        return this.adapter.getInputValue(fieldName);
    }

    @Override
    public FieldValue getInputValue(FieldPath fieldPath) {
        return this.adapter.getInputValue(fieldPath);
    }

    @Override
    public void tryOutputType(Expression exp, String fieldName, DataType valueType) {
        this.adapter.tryOutputType(exp, fieldName, valueType);
    }

    @Override
    public FieldValueAdapter setOutputValue(Expression exp, String fieldName, FieldValue fieldValue) {
        return this.adapter.setOutputValue(exp, fieldName, fieldValue);
    }

    public static FieldUpdateAdapter fromPartialUpdate(DocumentAdapter documentAdapter, ValueUpdate valueUpdate) {
        return new FieldUpdateAdapter(null, documentAdapter, new PartialBuilder(valueUpdate));
    }

    public static FieldUpdateAdapter fromPartialUpdate(Expression expression, DocumentAdapter documentAdapter, ValueUpdate valueUpdate) {
        return new FieldUpdateAdapter(expression, documentAdapter, new PartialBuilder(valueUpdate));
    }

    public static FieldUpdateAdapter fromCompleteUpdate(DocumentAdapter documentAdapter) {
        return new FieldUpdateAdapter(null, documentAdapter, new CompleteBuilder());
    }

    private static interface Builder {
        public List<ValueUpdate> build(FieldValue var1);
    }

    private static class PartialBuilder
    implements Builder {
        final ValueUpdate update;

        PartialBuilder(ValueUpdate update) {
            this.update = update;
        }

        @Override
        public List<ValueUpdate> build(FieldValue val) {
            return this.createValueUpdates(val, this.update);
        }

        List<ValueUpdate> createValueUpdates(FieldValue val, ValueUpdate upd) {
            ArrayList<ValueUpdate> lst = new ArrayList<ValueUpdate>();
            if (upd instanceof ClearValueUpdate) {
                lst.add((ValueUpdate)new ClearValueUpdate());
            } else if (upd instanceof AssignValueUpdate) {
                lst.add((ValueUpdate)new AssignValueUpdate(val));
            } else if (upd instanceof AddValueUpdate) {
                if (val instanceof Array) {
                    lst.addAll(this.createAddValueUpdateForArray((Array)val, ((AddValueUpdate)upd).getWeight()));
                } else if (val instanceof WeightedSet) {
                    lst.addAll(this.createAddValueUpdateForWset((WeightedSet)val));
                }
            } else if (upd instanceof ArithmeticValueUpdate) {
                lst.add(upd);
            } else if (upd instanceof RemoveValueUpdate) {
                if (val instanceof Array) {
                    lst.addAll(this.createRemoveValueUpdateForEachElement(((Array)val).fieldValueIterator()));
                } else if (val instanceof WeightedSet) {
                    lst.addAll(this.createRemoveValueUpdateForEachElement(((WeightedSet)val).fieldValueIterator()));
                }
            } else if (upd instanceof MapValueUpdate) {
                if (val instanceof Array) {
                    lst.addAll(this.createMapValueUpdatesForArray((Array)val, (MapValueUpdate)upd));
                } else {
                    if (val instanceof MapFieldValue) {
                        throw new UnsupportedOperationException("Can not map into a " + val.getClass().getName());
                    }
                    if (val instanceof StructuredFieldValue) {
                        lst.addAll(this.createMapValueUpdatesForStruct((StructuredFieldValue)val, (MapValueUpdate)upd));
                    } else if (val instanceof WeightedSet) {
                        lst.addAll(this.createMapValueUpdatesForWset((WeightedSet)val, (MapValueUpdate)upd));
                    }
                }
            } else if (upd instanceof TensorModifyUpdate) {
                lst.add(upd);
            } else if (upd instanceof TensorAddUpdate) {
                lst.add(upd);
            } else if (upd instanceof TensorRemoveUpdate) {
                lst.add(upd);
            } else {
                throw new UnsupportedOperationException("Value update type " + upd.getClass().getName() + " not supported");
            }
            return lst;
        }

        private List<ValueUpdate> createAddValueUpdateForArray(Array arr, int weight) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>(arr.size());
            Iterator it = arr.fieldValueIterator();
            while (it.hasNext()) {
                ret.add((ValueUpdate)new AddValueUpdate((FieldValue)it.next(), weight));
            }
            return ret;
        }

        private List<ValueUpdate> createAddValueUpdateForWset(WeightedSet wset) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>(wset.size());
            Iterator it = wset.fieldValueIterator();
            while (it.hasNext()) {
                FieldValue key = (FieldValue)it.next();
                ret.add((ValueUpdate)new AddValueUpdate(key, wset.get((Object)key).intValue()));
            }
            return ret;
        }

        private List<ValueUpdate> createRemoveValueUpdateForEachElement(Iterator<FieldValue> it) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            while (it.hasNext()) {
                ret.add((ValueUpdate)new RemoveValueUpdate(it.next()));
            }
            return ret;
        }

        private List<ValueUpdate> createMapValueUpdatesForArray(Array arr, MapValueUpdate upd) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            Iterator it = arr.fieldValueIterator();
            while (it.hasNext()) {
                FieldValue childVal = (FieldValue)it.next();
                for (ValueUpdate childUpd : this.createValueUpdates(childVal, upd.getUpdate())) {
                    ret.add((ValueUpdate)new MapValueUpdate(upd.getValue(), childUpd));
                }
            }
            return ret;
        }

        private List<ValueUpdate> createMapValueUpdatesForStruct(StructuredFieldValue struct, MapValueUpdate upd) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            for (Map.Entry entry : struct) {
                for (ValueUpdate childUpd : this.createValueUpdates((FieldValue)entry.getValue(), upd.getUpdate())) {
                    ret.add((ValueUpdate)new MapValueUpdate((FieldValue)new StringFieldValue(((Field)entry.getKey()).getName()), childUpd));
                }
            }
            return ret;
        }

        private List<ValueUpdate> createMapValueUpdatesForWset(WeightedSet wset, MapValueUpdate upd) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            Iterator it = wset.fieldValueIterator();
            while (it.hasNext()) {
                FieldValue childVal = (FieldValue)it.next();
                for (ValueUpdate childUpd : this.createValueUpdates((FieldValue)new IntegerFieldValue(wset.get((Object)childVal)), upd.getUpdate())) {
                    ret.add((ValueUpdate)new MapValueUpdate(childVal, childUpd));
                }
            }
            return ret;
        }
    }

    private static class CompleteBuilder
    extends PartialBuilder {
        static final ValueUpdate nullAssign = new AssignValueUpdate(null);

        CompleteBuilder() {
            super(null);
        }

        @Override
        List<ValueUpdate> createValueUpdates(FieldValue val, ValueUpdate upd) {
            return super.createValueUpdates(val, nullAssign);
        }
    }
}

