/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.math.BigInteger;

public final class HexDecodeExpression
extends Expression {
    private static final BigInteger ULONG_MAX = new BigInteger("18446744073709551616");

    public HexDecodeExpression() {
        super((DataType)DataType.STRING);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        BigInteger output;
        String input = String.valueOf(context.getValue());
        if (input.isEmpty()) {
            context.setValue((FieldValue)new LongFieldValue(Long.MIN_VALUE));
            return;
        }
        try {
            output = new BigInteger(input, 16);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Illegal hex value '" + input + "'.");
        }
        if (output.bitLength() > 64) {
            throw new NumberFormatException("Hex value '" + input + "' is out of range.");
        }
        if (output.compareTo(BigInteger.ZERO) == 1 && output.bitLength() == 64) {
            output = output.subtract(ULONG_MAX);
        }
        context.setValue((FieldValue)new LongFieldValue(output.longValue()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "hexdecode";
    }

    public boolean equals(Object obj) {
        return obj instanceof HexDecodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

