/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.FieldValueConverter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;

public final class ForEachExpression
extends CompositeExpression {
    private final Expression exp;

    public ForEachExpression(Expression exp) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.exp = exp;
    }

    public Expression getInnerExpression() {
        return this.exp;
    }

    @Override
    public ForEachExpression convertChildren(ExpressionConverter converter) {
        return new ForEachExpression(converter.convert(this.exp));
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.exp.setStatementOutput(documentType, field);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getValue();
        if (input instanceof Array || input instanceof WeightedSet) {
            FieldValue next = new MyConverter(context, this.exp).convert(input);
            if (next == null) {
                VerificationContext vctx = new VerificationContext(context);
                vctx.setValueType(input.getDataType()).execute(this);
                next = vctx.getValueType().createFieldValue();
            }
            context.setValue(next);
        } else if (input instanceof Struct) {
            context.setValue(new MyConverter(context, this.exp).convert(input));
        } else {
            throw new IllegalArgumentException("Expected Array, Struct or WeightedSet input, got " + input.getDataType().getName() + ".");
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType valueType = context.getValueType();
        if (valueType instanceof ArrayDataType || valueType instanceof WeightedSetDataType) {
            context.setValueType(((CollectionDataType)valueType).getNestedType());
            context.execute(this.exp);
            if (valueType instanceof ArrayDataType) {
                context.setValueType((DataType)DataType.getArray((DataType)context.getValueType()));
            } else {
                WeightedSetDataType wset = (WeightedSetDataType)valueType;
                context.setValueType((DataType)DataType.getWeightedSet((DataType)context.getValueType(), (boolean)wset.createIfNonExistent(), (boolean)wset.removeIfZero()));
            }
        } else if (valueType instanceof StructDataType) {
            for (Field field : ((StructDataType)valueType).getFields()) {
                DataType structValueType;
                DataType fieldType = field.getDataType();
                if (fieldType.isAssignableFrom(structValueType = context.setValueType(fieldType).execute(this.exp).getValueType())) continue;
                throw new VerificationException(this, "Expected " + fieldType.getName() + " output, got " + structValueType.getName() + ".");
            }
            context.setValueType(valueType);
        } else {
            throw new VerificationException(this, "Expected Array, Struct or WeightedSet input, got " + valueType.getName() + ".");
        }
    }

    @Override
    public DataType createdOutputType() {
        if (this.exp.createdOutputType() == null) {
            return null;
        }
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "for_each { " + this.exp + " }";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ForEachExpression)) {
            return false;
        }
        ForEachExpression rhs = (ForEachExpression)((Object)obj);
        return ((Object)((Object)this.exp)).equals((Object)rhs.exp);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.exp)).hashCode();
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        ForEachExpression.select((Selectable)this.exp, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    private static final class MyConverter
    extends FieldValueConverter {
        final ExecutionContext context;
        final Expression expression;
        int depth = 0;

        MyConverter(ExecutionContext context, Expression expression) {
            this.context = context;
            this.expression = expression;
        }

        @Override
        protected boolean shouldConvert(FieldValue value) {
            return ++this.depth > 1;
        }

        @Override
        protected FieldValue doConvert(FieldValue value) {
            this.context.setValue(value).execute(this.expression);
            return this.context.getValue();
        }
    }
}

