/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.javacc.FastCharStream;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.parser.CharStream;
import com.yahoo.vespa.indexinglanguage.parser.IndexingParser;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.vespa.indexinglanguage.parser.TokenMgrException;

public final class ScriptParser {
    public static Expression parseExpression(ScriptParserContext config) throws ParseException {
        return ScriptParser.parse(config, new ParserMethod<Expression>(){

            @Override
            public Expression call(IndexingParser parser) throws ParseException {
                return parser.root();
            }
        });
    }

    public static ScriptExpression parseScript(ScriptParserContext config) throws ParseException {
        return ScriptParser.parse(config, new ParserMethod<ScriptExpression>(){

            @Override
            public ScriptExpression call(IndexingParser parser) throws ParseException {
                return parser.script();
            }
        });
    }

    public static StatementExpression parseStatement(ScriptParserContext config) throws ParseException {
        return ScriptParser.parse(config, new ParserMethod<StatementExpression>(){

            @Override
            public StatementExpression call(IndexingParser parser) throws ParseException {
                try {
                    return parser.statement();
                }
                catch (TokenMgrException e) {
                    throw new ParseException(e.getMessage());
                }
            }
        });
    }

    private static <T extends Expression> T parse(ScriptParserContext config, ParserMethod<T> method) throws ParseException {
        CharStream input = config.getInputStream();
        IndexingParser parser = new IndexingParser(input);
        parser.setAnnotatorConfig(config.getAnnotatorConfig());
        parser.setDefaultFieldName(config.getDefaultFieldName());
        parser.setLinguistics(config.getLinguistcs());
        try {
            T t = method.call(parser);
            return t;
        }
        catch (ParseException e) {
            if (!(input instanceof FastCharStream)) {
                throw e;
            }
            throw new ParseException(((FastCharStream)input).formatException(e.getMessage()));
        }
        finally {
            if (parser.token != null && parser.token.next != null) {
                input.backup(parser.token.next.image.length());
            }
        }
    }

    private static interface ParserMethod<T extends Expression> {
        public T call(IndexingParser var1) throws ParseException;
    }
}

