/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.collections.Pair;
import com.yahoo.vespa.indexinglanguage.expressions.ArithmeticExpression;
import com.yahoo.vespa.indexinglanguage.expressions.CatExpression;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.GuardExpression;
import com.yahoo.vespa.indexinglanguage.expressions.IfThenExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ParenthesisExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SelectInputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SwitchExpression;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class ExpressionConverter
implements Cloneable {
    public final Expression convert(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (this.shouldConvert(exp)) {
            return this.doConvert(exp);
        }
        if (!(exp instanceof CompositeExpression)) {
            return exp;
        }
        try {
            return (Expression)((Object)ExpressionConverter.class.getMethod("innerConvert", ((Object)((Object)exp)).getClass()).invoke((Object)this, new Object[]{exp}));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new UnsupportedOperationException(((Object)((Object)exp)).getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
        }
    }

    public Expression innerConvert(ArithmeticExpression exp) {
        return new ArithmeticExpression(this.convert(exp.getLeftHandSide()), exp.getOperator(), this.convert(exp.getRightHandSide()));
    }

    public Expression innerConvert(CatExpression exp) {
        LinkedList<Expression> lst = new LinkedList<Expression>();
        for (Expression innerExp : exp) {
            Expression next = this.convert(innerExp);
            if (next == null) continue;
            lst.add(next);
        }
        return new CatExpression(lst);
    }

    public Expression innerConvert(ForEachExpression exp) {
        return new ForEachExpression(this.convert(exp.getInnerExpression()));
    }

    public Expression innerConvert(GuardExpression exp) {
        return new GuardExpression(this.convert(exp.getInnerExpression()));
    }

    public Expression innerConvert(IfThenExpression exp) {
        return new IfThenExpression(this.branch().convert(exp.getLeftHandSide()), exp.getComparator(), this.branch().convert(exp.getRightHandSide()), this.branch().convert(exp.getIfTrueExpression()), this.branch().convert(exp.getIfFalseExpression()));
    }

    public Expression innerConvert(ParenthesisExpression exp) {
        return new ParenthesisExpression(this.convert(exp.getInnerExpression()));
    }

    public Expression innerConvert(ScriptExpression exp) {
        LinkedList<StatementExpression> lst = new LinkedList<StatementExpression>();
        for (Expression innerExp : exp) {
            StatementExpression next = (StatementExpression)this.branch().convert(innerExp);
            if (next == null) continue;
            lst.add(next);
        }
        return new ScriptExpression(lst);
    }

    public Expression innerConvert(SelectInputExpression exp) {
        LinkedList<Pair<String, Expression>> cases = new LinkedList<Pair<String, Expression>>();
        for (Pair<String, Expression> pair : exp.getCases()) {
            cases.add((Pair<String, Expression>)new Pair(pair.getFirst(), (Object)this.branch().convert((Expression)((Object)pair.getSecond()))));
        }
        return new SelectInputExpression(cases);
    }

    public Expression innerConvert(StatementExpression exp) {
        LinkedList<Expression> lst = new LinkedList<Expression>();
        for (Expression innerExp : exp) {
            Expression next = this.convert(innerExp);
            if (next == null) continue;
            lst.add(next);
        }
        return new StatementExpression(lst);
    }

    public Expression innerConvert(SwitchExpression exp) {
        HashMap<String, Expression> cases = new HashMap<String, Expression>();
        for (Map.Entry<String, Expression> entry : exp.getCases().entrySet()) {
            Expression next = this.branch().convert(entry.getValue());
            if (next == null) continue;
            cases.put(entry.getKey(), next);
        }
        return new SwitchExpression(cases, this.branch().convert(exp.getDefaultExpression()));
    }

    protected ExpressionConverter branch() {
        return this;
    }

    public ExpressionConverter clone() {
        try {
            return (ExpressionConverter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected abstract boolean shouldConvert(Expression var1);

    protected abstract Expression doConvert(Expression var1);
}

