/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.geo.ZCurve;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public class ZCurveExpression
extends Expression {
    @Override
    protected void doExecute(ExecutionContext ctx) {
        Struct input = (Struct)ctx.getValue();
        Integer x = ZCurveExpression.getFieldValue(input, "x");
        Integer y = ZCurveExpression.getFieldValue(input, "y");
        if (x != null && y != null) {
            ctx.setValue((FieldValue)new LongFieldValue(ZCurve.encode((int)x, (int)y)));
        } else {
            ctx.setValue(null);
        }
    }

    private static Integer getFieldValue(Struct struct, String fieldName) {
        IntegerFieldValue val = (IntegerFieldValue)struct.getFieldValue(fieldName);
        return val != null ? Integer.valueOf(val.getInteger()) : null;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType requiredInputType() {
        return PositionDataType.INSTANCE;
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "zcurve";
    }

    public boolean equals(Object obj) {
        return obj instanceof ZCurveExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

