/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public class ToArrayExpression
extends Expression {
    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        DataType inputType = input.getDataType();
        ArrayDataType outputType = DataType.getArray((DataType)inputType);
        Array output = outputType.createFieldValue();
        output.add(input);
        ctx.setValue((FieldValue)output);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue((DataType)DataType.getArray((DataType)context.getValue()));
    }

    @Override
    public DataType requiredInputType() {
        return UnresolvedDataType.INSTANCE;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "to_array";
    }

    public boolean equals(Object obj) {
        return obj instanceof ToArrayExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

