/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public class GetFieldExpression
extends Expression {
    private final String fieldName;

    public GetFieldExpression(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        if (!(input instanceof StructuredFieldValue)) {
            throw new IllegalArgumentException("Expected structured input, got " + input.getDataType().getName() + ".");
        }
        StructuredFieldValue struct = (StructuredFieldValue)input;
        Field field = struct.getField(this.fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field '" + this.fieldName + "' not found.");
        }
        ctx.setValue(struct.getFieldValue(field));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        if (!(input instanceof StructuredDataType)) {
            throw new VerificationException(this, "Expected structured input, got " + input.getName() + ".");
        }
        Field field = ((StructuredDataType)input).getField(this.fieldName);
        if (field == null) {
            throw new VerificationException(this, "Field '" + this.fieldName + "' not found.");
        }
        context.setValue(field.getDataType());
    }

    @Override
    public DataType requiredInputType() {
        return UnresolvedDataType.INSTANCE;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "get_field " + this.fieldName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GetFieldExpression)) {
            return false;
        }
        GetFieldExpression rhs = (GetFieldExpression)((Object)obj);
        return this.fieldName.equals(rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.fieldName.hashCode();
    }
}

