/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespa.indexinglanguage.AdapterFactory;
import com.yahoo.vespa.indexinglanguage.DocumentAdapter;
import com.yahoo.vespa.indexinglanguage.FieldPathUpdateAdapter;
import com.yahoo.vespa.indexinglanguage.FieldPathUpdateHelper;
import com.yahoo.vespa.indexinglanguage.FieldUpdateAdapter;
import com.yahoo.vespa.indexinglanguage.FieldUpdateHelper;
import com.yahoo.vespa.indexinglanguage.SimpleDocumentAdapter;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.ArrayList;
import java.util.List;

public class SimpleAdapterFactory
implements AdapterFactory {
    private final SelectExpression expressionSelector;

    public SimpleAdapterFactory() {
        this(new SelectExpression());
    }

    public SimpleAdapterFactory(SelectExpression expressionSelector) {
        this.expressionSelector = expressionSelector;
    }

    @Override
    public DocumentAdapter newDocumentAdapter(Document doc) {
        return this.newDocumentAdapter(doc, false);
    }

    public DocumentAdapter newDocumentAdapter(Document doc, boolean isUpdate) {
        if (isUpdate) {
            return new SimpleDocumentAdapter(doc);
        }
        return new SimpleDocumentAdapter(doc, doc);
    }

    @Override
    public List<UpdateAdapter> newUpdateAdapterList(DocumentUpdate upd) {
        ArrayList<UpdateAdapter> ret = new ArrayList<UpdateAdapter>();
        DocumentType docType = upd.getDocumentType();
        DocumentId docId = upd.getId();
        Document complete = new Document(docType, upd.getId());
        for (FieldPathUpdate fieldUpd : upd) {
            if (FieldPathUpdateHelper.isComplete(fieldUpd)) {
                FieldPathUpdateHelper.applyUpdate(fieldUpd, complete);
                continue;
            }
            Document partial = FieldPathUpdateHelper.newPartialDocument(docId, fieldUpd);
            ret.add(new FieldPathUpdateAdapter(this.newDocumentAdapter(partial, true), fieldUpd));
        }
        for (FieldPathUpdate fieldUpd : upd.getFieldUpdates()) {
            Field field = fieldUpd.getField();
            for (ValueUpdate valueUpd : fieldUpd.getValueUpdates()) {
                if (FieldUpdateHelper.isComplete(field, valueUpd)) {
                    FieldUpdateHelper.applyUpdate(field, valueUpd, complete);
                    continue;
                }
                Document partial = FieldUpdateHelper.newPartialDocument(docType, docId, field, valueUpd);
                ret.add(FieldUpdateAdapter.fromPartialUpdate(this.expressionSelector.selectExpression(docType, field.getName()), this.newDocumentAdapter(partial, true), valueUpd));
            }
        }
        ret.add(FieldUpdateAdapter.fromCompleteUpdate(this.newDocumentAdapter(complete, true)));
        return ret;
    }

    public static class SelectExpression {
        public Expression selectExpression(DocumentType documentType, String fieldName) {
            return null;
        }
    }
}

