/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http.hc5;

import ai.vespa.util.http.hc5.HttpToHttpsRoutePlanner;
import ai.vespa.util.http.hc5.SslConnectionSocketFactory;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class VespaHttpClientBuilder {
    private HttpClientConnectionManagerFactory connectionManagerFactory = PoolingHttpClientConnectionManager::new;
    private HostnameVerifier hostnameVerifier = new NoopHostnameVerifier();
    private boolean rewriteHttpToHttps = true;
    private final ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();

    private VespaHttpClientBuilder() {
    }

    public static VespaHttpClientBuilder custom() {
        return new VespaHttpClientBuilder();
    }

    public VespaHttpClientBuilder connectionManagerFactory(HttpClientConnectionManagerFactory connectionManagerFactory) {
        this.connectionManagerFactory = connectionManagerFactory;
        return this;
    }

    public VespaHttpClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public VespaHttpClientBuilder rewriteHttpToHttps(boolean enable) {
        this.rewriteHttpToHttps = enable;
        return this;
    }

    public VespaHttpClientBuilder connectTimeout(long connectTimeout, TimeUnit timeUnit) {
        this.connectionConfigBuilder.setConnectTimeout(connectTimeout, timeUnit);
        return this;
    }

    public VespaHttpClientBuilder connectTimeout(Timeout connectTimeout) {
        this.connectionConfigBuilder.setConnectTimeout(connectTimeout);
        return this;
    }

    public VespaHttpClientBuilder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.connectionConfigBuilder.setSocketTimeout(socketTimeout, timeUnit);
        return this;
    }

    public VespaHttpClientBuilder socketTimeout(Timeout socketTimeout) {
        this.connectionConfigBuilder.setSocketTimeout(socketTimeout);
        return this;
    }

    public VespaHttpClientBuilder validateAfterInactivity(TimeValue validateAfterInactivity) {
        this.connectionConfigBuilder.setValidateAfterInactivity(validateAfterInactivity);
        return this;
    }

    public HttpClientBuilder apacheBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        VespaHttpClientBuilder.addSslSocketFactory(builder, new HttpClientConnectionManagerFactoryProxy(), this.hostnameVerifier);
        if (this.rewriteHttpToHttps) {
            VespaHttpClientBuilder.addHttpsRewritingRoutePlanner(builder);
        }
        builder.disableConnectionState();
        builder.disableCookieManagement();
        builder.disableAuthCaching();
        builder.disableRedirectHandling();
        return builder;
    }

    public CloseableHttpClient buildClient() {
        return this.apacheBuilder().build();
    }

    private static void addSslSocketFactory(HttpClientBuilder builder, HttpClientConnectionManagerFactory connectionManagerFactory, HostnameVerifier hostnameVerifier) {
        TransportSecurityUtils.getSystemTlsContext().ifPresent(tlsContext -> {
            SSLConnectionSocketFactory socketFactory = SslConnectionSocketFactory.of(tlsContext, hostnameVerifier);
            builder.setConnectionManager((HttpClientConnectionManager)connectionManagerFactory.create(VespaHttpClientBuilder.createRegistry(socketFactory)));
            builder.setUserTokenHandler((route, context) -> null);
        });
    }

    private static Registry<ConnectionSocketFactory> createRegistry(SSLConnectionSocketFactory sslSocketFactory) {
        return RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    private static void addHttpsRewritingRoutePlanner(HttpClientBuilder builder) {
        if (TransportSecurityUtils.isTransportSecurityEnabled() && TransportSecurityUtils.getInsecureMixedMode() != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
            builder.setRoutePlanner((HttpRoutePlanner)new HttpToHttpsRoutePlanner());
        }
    }

    public static interface HttpClientConnectionManagerFactory {
        public PoolingHttpClientConnectionManager create(Registry<ConnectionSocketFactory> var1);
    }

    private class HttpClientConnectionManagerFactoryProxy
    implements HttpClientConnectionManagerFactory {
        private HttpClientConnectionManagerFactoryProxy() {
        }

        @Override
        public PoolingHttpClientConnectionManager create(Registry<ConnectionSocketFactory> socketFactories) {
            PoolingHttpClientConnectionManager manager = VespaHttpClientBuilder.this.connectionManagerFactory.create(socketFactories);
            manager.setDefaultConnectionConfig(VespaHttpClientBuilder.this.connectionConfigBuilder.build());
            return manager;
        }
    }
}

