/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http.hc4;

import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;

public class VespaHttpClientBuilder {
    private static final Logger log = Logger.getLogger(VespaHttpClientBuilder.class.getName());

    private VespaHttpClientBuilder() {
    }

    public static HttpClientBuilder create() {
        return VespaHttpClientBuilder.createBuilder(null);
    }

    public static HttpClientBuilder create(ConnectionManagerFactory connectionManagerFactory) {
        return VespaHttpClientBuilder.createBuilder(connectionManagerFactory);
    }

    public static HttpClientBuilder createWithBasicConnectionManager() {
        return VespaHttpClientBuilder.createBuilder(BasicHttpClientConnectionManager::new);
    }

    private static HttpClientBuilder createBuilder(ConnectionManagerFactory connectionManagerFactory) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        VespaHttpClientBuilder.addSslSocketFactory(builder, connectionManagerFactory);
        VespaHttpClientBuilder.addHttpsRewritingRoutePlanner(builder);
        return builder;
    }

    private static void addSslSocketFactory(HttpClientBuilder builder, ConnectionManagerFactory connectionManagerFactory) {
        TransportSecurityUtils.getSystemTlsContext().ifPresent(tlsContext -> {
            log.log(Level.FINE, "Adding ssl socket factory to client");
            SSLConnectionSocketFactory socketFactory = VespaHttpClientBuilder.createSslSocketFactory(tlsContext);
            if (connectionManagerFactory != null) {
                builder.setConnectionManager(connectionManagerFactory.create(VespaHttpClientBuilder.createRegistry(socketFactory)));
            } else {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            }
            builder.setUserTokenHandler(context -> null);
        });
    }

    private static void addHttpsRewritingRoutePlanner(HttpClientBuilder builder) {
        if (TransportSecurityUtils.isTransportSecurityEnabled() && TransportSecurityUtils.getInsecureMixedMode() != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
            builder.setRoutePlanner((HttpRoutePlanner)new HttpToHttpsRoutePlanner());
        }
    }

    private static SSLConnectionSocketFactory createSslSocketFactory(TlsContext tlsContext) {
        SSLParameters parameters = tlsContext.parameters();
        return new SSLConnectionSocketFactory(tlsContext.context(), parameters.getProtocols(), parameters.getCipherSuites(), (HostnameVerifier)new NoopHostnameVerifier());
    }

    private static Registry<ConnectionSocketFactory> createRegistry(SSLConnectionSocketFactory sslSocketFactory) {
        return RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
    }

    public static interface ConnectionManagerFactory {
        public HttpClientConnectionManager create(Registry<ConnectionSocketFactory> var1);
    }

    static class HttpToHttpsRoutePlanner
    implements HttpRoutePlanner {
        HttpToHttpsRoutePlanner() {
        }

        public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            RequestConfig config = clientContext.getRequestConfig();
            InetAddress local = config.getLocalAddress();
            HttpHost target = this.resolveTarget(host);
            boolean secure = target.getSchemeName().equalsIgnoreCase("https");
            return new HttpRoute(target, local, secure);
        }

        private HttpHost resolveTarget(HttpHost host) throws HttpException {
            try {
                String originalScheme = host.getSchemeName();
                String scheme = originalScheme.equalsIgnoreCase("http") ? "https" : originalScheme;
                int port = DefaultSchemePortResolver.INSTANCE.resolve(host);
                return new HttpHost(host.getHostName(), port, scheme);
            }
            catch (UnsupportedSchemeException e) {
                throw new HttpException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

