/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http;

import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;

public class VespaAsyncHttpClientBuilder {
    public static HttpAsyncClientBuilder create() {
        return VespaAsyncHttpClientBuilder.create(tlsStrategy -> PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build());
    }

    public static HttpAsyncClientBuilder create(AsyncConnectionManagerFactory factory) {
        TlsStrategy tlsStrategy;
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClientBuilder.create();
        TlsContext vespaTlsContext = TransportSecurityUtils.getSystemTlsContext().orElse(null);
        if (vespaTlsContext != null) {
            SSLParameters vespaTlsParameters = vespaTlsContext.parameters();
            tlsStrategy = ClientTlsStrategyBuilder.create().setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setSslContext(vespaTlsContext.context()).setTlsVersions(vespaTlsParameters.getProtocols()).setCiphers(vespaTlsParameters.getCipherSuites()).build();
            if (TransportSecurityUtils.getInsecureMixedMode() != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
                clientBuilder.setRoutePlanner((HttpRoutePlanner)new HttpToHttpsRoutePlanner());
            }
        } else {
            tlsStrategy = ClientTlsStrategyBuilder.create().build();
        }
        clientBuilder.disableConnectionState();
        clientBuilder.disableCookieManagement();
        clientBuilder.disableAuthCaching();
        clientBuilder.disableRedirectHandling();
        clientBuilder.setConnectionManager(factory.create(tlsStrategy));
        clientBuilder.setConnectionManagerShared(false);
        return clientBuilder;
    }

    private static class HttpToHttpsRoutePlanner
    implements HttpRoutePlanner {
        private final DefaultRoutePlanner defaultPlanner = new DefaultRoutePlanner((SchemePortResolver)new DefaultSchemePortResolver());

        private HttpToHttpsRoutePlanner() {
        }

        public HttpRoute determineRoute(HttpHost target, HttpContext context) throws HttpException {
            HttpRoute originalRoute = this.defaultPlanner.determineRoute(target, context);
            HttpHost originalHost = originalRoute.getTargetHost();
            String originalScheme = originalHost.getSchemeName();
            String rewrittenScheme = originalScheme.equalsIgnoreCase("http") ? "https" : originalScheme;
            boolean rewrittenSecure = target.getSchemeName().equalsIgnoreCase("https");
            HttpHost rewrittenHost = new HttpHost(rewrittenScheme, originalHost.getAddress(), originalHost.getHostName(), originalHost.getPort());
            return new HttpRoute(rewrittenHost, originalRoute.getLocalAddress(), originalRoute.getProxyHost(), rewrittenSecure, originalRoute.getTunnelType(), originalRoute.getLayerType());
        }
    }

    public static interface AsyncConnectionManagerFactory {
        public AsyncClientConnectionManager create(TlsStrategy var1);
    }
}

