/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.client;

import ai.vespa.hosted.client.HttpClient;
import ai.vespa.http.HttpURL;
import ai.vespa.json.Json;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.time.TimeBudget;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;

public abstract class AbstractHttpClient
implements HttpClient {
    private static final Logger log = Logger.getLogger(AbstractHttpClient.class.getName());

    public static HttpClient wrapping(final CloseableHttpClient client) {
        return new AbstractHttpClient(){

            @Override
            protected ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientContext context) throws IOException {
                return client.execute(request, (HttpContext)context);
            }

            @Override
            public void close() throws IOException {
                client.close();
            }
        };
    }

    protected abstract ClassicHttpResponse execute(ClassicHttpRequest var1, HttpClientContext var2) throws IOException;

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(RequestBuilder builder, BiFunction<ClassicHttpResponse, ClassicHttpRequest, T> handler, HttpClient.ExceptionHandler catcher) {
        Object thrown = null;
        for (URI host : builder.hosts) {
            HttpURL.Query query = builder.query;
            for (Supplier<HttpURL.Query> dynamic : builder.dynamicQuery) {
                query = query.set(dynamic.get().lastEntries());
            }
            ClassicHttpRequest request = ClassicRequestBuilder.create((String)builder.method.name()).setUri(HttpURL.from((URI)host).appendPath(builder.path).appendQuery(query).asURI()).build();
            builder.headers.forEach((name, values) -> values.forEach(value -> request.setHeader(name, value)));
            try (HttpEntity entity = builder.entity.get();){
                ClassicHttpResponse classicHttpResponse;
                request.setEntity(entity);
                try {
                    classicHttpResponse = handler.apply(this.execute(request, this.contextWithTimeout(builder)), request);
                }
                catch (IOException e) {
                    catcher.handle(e, request);
                    throw HttpClient.RetryException.wrap(e, request);
                }
                return (T)classicHttpResponse;
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed closing request entity", e);
            }
            catch (HttpClient.RetryException e) {
                if (thrown == null) {
                    thrown = e.getCause();
                } else {
                    ((Throwable)thrown).addSuppressed(e.getCause());
                }
                log.log(Level.FINE, e.getCause(), () -> String.valueOf(request) + " failed; will retry");
            }
        }
        if (thrown != null) {
            if (thrown instanceof IOException) {
                throw new UncheckedIOException((IOException)thrown);
            }
            if (thrown instanceof RuntimeException) {
                throw (RuntimeException)thrown;
            }
            throw new IllegalStateException("Illegal retry cause: " + String.valueOf(thrown.getClass()), (Throwable)thrown);
        }
        throw new IllegalStateException("No hosts to perform the request against");
    }

    private HttpClientContext contextWithTimeout(RequestBuilder builder) {
        Optional remaining;
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = builder.config;
        if (builder.deadline != null && (remaining = builder.deadline.timeLeftOrThrow()).isPresent()) {
            config = RequestConfig.copy((RequestConfig)config).setConnectTimeout(AbstractHttpClient.min(config.getConnectTimeout(), (Duration)remaining.get())).setConnectionRequestTimeout(AbstractHttpClient.min(config.getConnectionRequestTimeout(), (Duration)remaining.get())).setResponseTimeout(AbstractHttpClient.min(config.getResponseTimeout(), (Duration)remaining.get())).build();
        }
        context.setRequestConfig(config);
        return context;
    }

    static Timeout min(Timeout first, Duration second) {
        long firstMillis = first == null || first.isDisabled() ? second.toMillis() : first.toMilliseconds();
        return Timeout.ofMilliseconds((long)Math.min(firstMillis, second.toMillis()));
    }

    @Override
    public HttpClient.RequestBuilder send(HttpClient.HostStrategy hosts, Method method) {
        return new RequestBuilder(hosts, method);
    }

    private static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }

    class RequestBuilder
    implements HttpClient.RequestBuilder {
        private final Method method;
        private final HttpClient.HostStrategy hosts;
        private final List<Supplier<HttpURL.Query>> dynamicQuery = new ArrayList<Supplier<HttpURL.Query>>();
        private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        private HttpURL.Path path = HttpURL.Path.empty();
        private HttpURL.Query query = HttpURL.Query.empty();
        private Supplier<HttpEntity> entity = () -> null;
        private RequestConfig config = HttpClient.defaultRequestConfig;
        private HttpClient.ResponseVerifier verifier = HttpClient.throwOnError;
        private HttpClient.ExceptionHandler catcher = HttpClient.retryAll;
        private TimeBudget deadline;

        private RequestBuilder(HttpClient.HostStrategy hosts, Method method) {
            if (!hosts.iterator().hasNext()) {
                throw new IllegalArgumentException("Host strategy cannot be empty");
            }
            this.hosts = hosts;
            this.method = Objects.requireNonNull(method);
        }

        @Override
        public RequestBuilder at(HttpURL.Path subPath) {
            this.path = this.path.append(subPath);
            return this;
        }

        @Override
        public HttpClient.RequestBuilder body(byte[] json) {
            return this.body(() -> HttpEntities.create((byte[])json, (ContentType)ContentType.APPLICATION_JSON));
        }

        @Override
        public RequestBuilder body(Supplier<HttpEntity> entity) {
            this.entity = Objects.requireNonNull(entity);
            return this;
        }

        @Override
        public HttpClient.RequestBuilder emptyParameters(List<String> keys) {
            for (String key : keys) {
                this.query = this.query.add(key);
            }
            return this;
        }

        @Override
        public RequestBuilder parameters(List<String> pairs) {
            if (pairs.size() % 2 != 0) {
                throw new IllegalArgumentException("Must supply parameter key/values in pairs");
            }
            int i = 0;
            while (i < pairs.size()) {
                String value;
                String key = pairs.get(i++);
                if ((value = pairs.get(i++)) == null) continue;
                this.query = this.query.add(key, value);
            }
            return this;
        }

        @Override
        public HttpClient.RequestBuilder parameters(HttpURL.Query query) {
            this.query = this.query.add(query.entries());
            return this;
        }

        @Override
        public HttpClient.RequestBuilder parameters(Supplier<HttpURL.Query> query) {
            this.dynamicQuery.add(query);
            return this;
        }

        @Override
        public RequestBuilder timeout(Duration timeout) {
            return this.config(RequestConfig.copy((RequestConfig)this.config).setResponseTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build());
        }

        @Override
        public HttpClient.RequestBuilder deadline(TimeBudget deadline) {
            this.deadline = Objects.requireNonNull(deadline);
            return this;
        }

        @Override
        public HttpClient.RequestBuilder addHeader(String name, String value) {
            this.headers.computeIfAbsent(name, __ -> new ArrayList()).add(value);
            return this;
        }

        @Override
        public HttpClient.RequestBuilder setHeader(String name, String value) {
            this.headers.put(name, new ArrayList<String>(List.of(value)));
            return this;
        }

        @Override
        public RequestBuilder config(RequestConfig config) {
            this.config = Objects.requireNonNull(config);
            return this;
        }

        @Override
        public RequestBuilder catching(HttpClient.ExceptionHandler catcher) {
            this.catcher = Objects.requireNonNull(catcher);
            return this;
        }

        @Override
        public RequestBuilder throwing(HttpClient.ResponseVerifier verifier) {
            this.verifier = Objects.requireNonNull(verifier);
            return this;
        }

        @Override
        public String read() {
            return this.handle((response, __) -> {
                String string;
                block8: {
                    ClassicHttpResponse classicHttpResponse = response;
                    try {
                        String string2 = string = response.getEntity() == null ? "" : EntityUtils.toString((HttpEntity)response.getEntity());
                        if (classicHttpResponse == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (classicHttpResponse != null) {
                                try {
                                    classicHttpResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ParseException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    classicHttpResponse.close();
                }
                return string;
            });
        }

        @Override
        public <T> T read(Function<byte[], T> mapper) {
            return (T)this.handle((response, __) -> {
                try (ClassicHttpResponse classicHttpResponse = response;){
                    Object r = mapper.apply(response.getEntity() == null ? new byte[]{} : EntityUtils.toByteArray((HttpEntity)response.getEntity()));
                    return r;
                }
            });
        }

        @Override
        public Json readAsJson() {
            return this.read(bytes -> Json.of((Slime)SlimeUtils.jsonToSlime((byte[])bytes)));
        }

        @Override
        public void discard() throws UncheckedIOException, HttpClient.ResponseException {
            this.handle((response, __) -> {
                try (ClassicHttpResponse classicHttpResponse = response;){
                    Object var3_3 = null;
                    return var3_3;
                }
            });
        }

        @Override
        public HttpClient.HttpInputStream stream() throws UncheckedIOException, HttpClient.ResponseException {
            return this.handle((response, __) -> new HttpClient.HttpInputStream(response));
        }

        @Override
        public <T> T handle(HttpClient.ResponseHandler<T> handler) {
            return (T)AbstractHttpClient.this.execute(this, (response, request) -> {
                try {
                    this.verifier.verify((ClassicHttpResponse)response, (ClassicHttpRequest)request);
                    return handler.handle((ClassicHttpResponse)response, (ClassicHttpRequest)request);
                }
                catch (IOException | Error | RuntimeException e) {
                    try {
                        response.close();
                    }
                    catch (IOException f) {
                        e.addSuppressed(f);
                    }
                    if (e instanceof IOException) {
                        this.catcher.handle((IOException)e, (ClassicHttpRequest)request);
                        throw HttpClient.RetryException.wrap((IOException)e, request);
                    }
                    AbstractHttpClient.sneakyThrow(e);
                    throw new AssertionError((Object)"Should not happen");
                }
            }, this.catcher);
        }
    }
}

