/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.SlimeUtils;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TestConfig {
    private final ApplicationId application;
    private final ZoneId zone;
    private final SystemName system;
    private final boolean isCI;
    private final String platform;
    private final long revision;
    private final Instant deployedAt;
    private final Map<ZoneId, Map<String, URI>> deployments;
    private final Map<ZoneId, List<String>> contentClusters;

    public TestConfig(ApplicationId application, ZoneId zone, SystemName system, boolean isCI, String platform, long revision, Instant deployedAt, Map<ZoneId, Map<String, URI>> deployments, Map<ZoneId, List<String>> contentClusters) {
        if (!deployments.containsKey(zone)) {
            throw new IllegalArgumentException("Config must contain a deployment for its zone, but only does for " + deployments.keySet());
        }
        this.application = Objects.requireNonNull(application);
        this.zone = Objects.requireNonNull(zone);
        this.system = Objects.requireNonNull(system);
        this.isCI = isCI;
        this.platform = platform;
        this.revision = revision;
        this.deployedAt = deployedAt;
        this.deployments = deployments.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> (ZoneId)entry.getKey(), entry -> Map.copyOf((Map)entry.getValue())));
        this.contentClusters = contentClusters.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> (ZoneId)entry.getKey(), entry -> List.copyOf((Collection)entry.getValue())));
    }

    public static TestConfig fromJson(byte[] jsonBytes) {
        Cursor config = SlimeUtils.jsonToSlime((byte[])jsonBytes).get();
        if (config.field("localEndpoints").valid()) {
            return TestConfig.fromEndpointsOnly(TestConfig.toClusterMap(config.field("localEndpoints")));
        }
        ApplicationId application = ApplicationId.fromSerializedForm((String)config.field("application").asString());
        ZoneId zone = ZoneId.from((String)config.field("zone").asString());
        SystemName system = SystemName.from((String)config.field("system").asString());
        boolean isCI = config.field("isCI").asBool();
        String platform = config.field("platform").asString();
        long revision = config.field("revision").asLong();
        Instant deployedAt = Instant.ofEpochMilli(config.field("deployedAt").asLong());
        HashMap<ZoneId, Map<String, URI>> deployments = new HashMap<ZoneId, Map<String, URI>>();
        config.field("zoneEndpoints").traverse((zoneId, clustersObject) -> deployments.put(ZoneId.from((String)zoneId), TestConfig.toClusterMap(clustersObject)));
        HashMap<ZoneId, List<String>> contentClusters = new HashMap<ZoneId, List<String>>();
        config.field("clusters").traverse((zoneId, clustersArray) -> {
            ArrayList clusters = new ArrayList();
            clustersArray.traverse((__, cluster) -> clusters.add(cluster.asString()));
            contentClusters.put(ZoneId.from((String)zoneId), clusters);
        });
        return new TestConfig(application, zone, system, isCI, platform, revision, deployedAt, deployments, contentClusters);
    }

    static Map<String, URI> toClusterMap(Inspector clustersObject) {
        HashMap<String, URI> clusters = new HashMap<String, URI>();
        clustersObject.traverse((cluster, uri) -> clusters.put(cluster, URI.create(uri.asString())));
        return clusters;
    }

    public static TestConfig fromEndpointsOnly(Map<String, URI> endpoints) {
        return new TestConfig(ApplicationId.defaultId(), ZoneId.defaultId(), SystemName.dev, false, "", 0L, Instant.EPOCH, Map.of(ZoneId.defaultId(), endpoints), Map.of());
    }

    public ApplicationId application() {
        return this.application;
    }

    public ZoneId zone() {
        return this.zone;
    }

    public SystemName system() {
        return this.system;
    }

    public boolean isCI() {
        return this.isCI;
    }

    public Map<ZoneId, Map<String, URI>> deployments() {
        return this.deployments;
    }

    public Map<ZoneId, List<String>> contentClusters() {
        return this.contentClusters;
    }

    public String platformVersion() {
        return this.platform;
    }

    public long applicationVersion() {
        return this.revision;
    }

    public Instant deployedAt() {
        return this.deployedAt;
    }
}

