/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.Slime;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TestConfig {
    private final ApplicationId application;
    private final ZoneId zone;
    private final SystemName system;
    private final Map<ZoneId, Map<String, URI>> deployments;

    public TestConfig(ApplicationId application, ZoneId zone, SystemName system, Map<ZoneId, Map<String, URI>> deployments) {
        if (!deployments.containsKey(zone)) {
            throw new IllegalArgumentException("Config must contain a deployment for its zone, but only does for " + deployments.keySet());
        }
        this.application = Objects.requireNonNull(application);
        this.zone = Objects.requireNonNull(zone);
        this.system = Objects.requireNonNull(system);
        this.deployments = deployments.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> (ZoneId)entry.getKey(), entry -> Map.copyOf((Map)entry.getValue())));
    }

    public static TestConfig fromJson(byte[] jsonBytes) {
        Cursor config = new JsonDecoder().decode(new Slime(), jsonBytes).get();
        if (config.field("clusters").valid()) {
            return TestConfig.fromEndpointsOnly(TestConfig.toClusterMap(config.field("clusters")));
        }
        ApplicationId application = ApplicationId.fromSerializedForm((String)config.field("application").asString());
        ZoneId zone = ZoneId.from((String)config.field("zone").asString());
        SystemName system = SystemName.from((String)config.field("system").asString());
        HashMap<ZoneId, Map<String, URI>> deployments = new HashMap<ZoneId, Map<String, URI>>();
        config.field("zoneEndpoints").traverse((zoneId, clustersObject) -> deployments.put(ZoneId.from((String)zoneId), TestConfig.toClusterMap(clustersObject)));
        return new TestConfig(application, zone, system, deployments);
    }

    static Map<String, URI> toClusterMap(Inspector clustersObject) {
        HashMap<String, URI> clusters = new HashMap<String, URI>();
        clustersObject.traverse((cluster, uri) -> clusters.put(cluster, URI.create(uri.asString())));
        return clusters;
    }

    public static TestConfig fromEndpointsOnly(Map<String, URI> endpoints) {
        return new TestConfig(ApplicationId.defaultId(), ZoneId.defaultId(), SystemName.defaultSystem(), Map.of(ZoneId.defaultId(), endpoints));
    }

    public ApplicationId application() {
        return this.application;
    }

    public ZoneId zone() {
        return this.zone;
    }

    public Map<ZoneId, Map<String, URI>> deployments() {
        return this.deployments;
    }

    public SystemName system() {
        return this.system;
    }
}

