/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;
import java.util.function.Predicate;

public class JacksonSerializer<T>
implements FlagSerializer<T> {
    private final Class<T> jacksonClass;
    private final Predicate<T> validator;

    public JacksonSerializer(Class<T> jacksonClass, Predicate<T> validator) {
        this.jacksonClass = jacksonClass;
        this.validator = validator;
    }

    @Override
    public T deserialize(RawFlag rawFlag) {
        T value = JsonNodeRawFlag.fromJsonNode(rawFlag.asJsonNode()).toJacksonClass(this.jacksonClass);
        if (!this.validator.test(value)) {
            throw new IllegalArgumentException("Invalid " + this.jacksonClass.getSimpleName() + " value: " + rawFlag.asJson());
        }
        return value;
    }

    @Override
    public RawFlag serialize(T value) {
        return JsonNodeRawFlag.fromJacksonClass(value);
    }
}

