/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.vespa.flags.custom.SidecarResources;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record Sidecar(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="image") String image, @JsonProperty(value="resources") SidecarResources resources, @JsonProperty(value="volumeMounts") List<String> volumeMounts, @JsonProperty(value="envs") Map<String, String> envs, @JsonProperty(value="command") List<String> command) {
    private static final int MIN_ID = 0;
    private static final int MAX_ID = 99;

    @JsonCreator
    public Sidecar {
        if (id < 0 || id > 99) {
            throw new IllegalArgumentException("Sidecar id must be between 0 and 99, actual: %s".formatted(id));
        }
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Sidecar name must be specified");
        }
        if (image == null || image.isBlank()) {
            throw new IllegalArgumentException("Sidecar image must be specified");
        }
        resources = resources == null ? SidecarResources.DEFAULT : resources;
        volumeMounts = volumeMounts == null ? List.of() : volumeMounts;
        envs = envs == null ? Map.of() : envs;
        command = command == null ? List.of() : command;
    }
}

