/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;
import java.util.function.Function;
import java.util.function.Predicate;

public class SimpleFlagSerializer<T>
implements FlagSerializer<T> {
    private final Function<T, JsonNode> serializer;
    private final Predicate<JsonNode> isCorrectType;
    private final Function<JsonNode, T> deserializer;

    public SimpleFlagSerializer(Function<T, JsonNode> serializer, Predicate<JsonNode> isCorrectType, Function<JsonNode, T> deserializer) {
        this.serializer = serializer;
        this.isCorrectType = isCorrectType;
        this.deserializer = deserializer;
    }

    @Override
    public JsonNodeRawFlag serialize(T value) {
        return JsonNodeRawFlag.fromJsonNode(this.serializer.apply(value));
    }

    @Override
    public T deserialize(RawFlag rawFlag) {
        JsonNode jsonNode = rawFlag.asJsonNode();
        if (!this.isCorrectType.test(jsonNode)) {
            throw new IllegalArgumentException("Wrong type of JsonNode: " + String.valueOf(jsonNode.getNodeType()));
        }
        return this.deserializer.apply(jsonNode);
    }
}

