/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.vespa.flags.RawFlag;
import com.yahoo.yolean.Exceptions;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class JsonNodeRawFlag
implements RawFlag {
    private static final AtomicReference<ObjectMapper> mapper = new AtomicReference();
    private final JsonNode jsonNode;

    private JsonNodeRawFlag(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public static JsonNodeRawFlag fromJson(String json) {
        return new JsonNodeRawFlag((JsonNode)Exceptions.uncheck(() -> JsonNodeRawFlag.objectMapper().readTree(json)));
    }

    public static JsonNodeRawFlag fromJsonNode(JsonNode jsonNode) {
        return new JsonNodeRawFlag(jsonNode);
    }

    public static <T> JsonNodeRawFlag fromJacksonClass(T value) {
        return new JsonNodeRawFlag((JsonNode)Exceptions.uncheck(() -> JsonNodeRawFlag.objectMapper().valueToTree(value)));
    }

    public <T> T toJacksonClass(Class<T> jacksonClass) {
        return (T)Exceptions.uncheck(() -> JsonNodeRawFlag.objectMapper().treeToValue((TreeNode)this.jsonNode, jacksonClass));
    }

    public <T> T toJacksonClass(JavaType jacksonClass) {
        return (T)Exceptions.uncheck(() -> JsonNodeRawFlag.objectMapper().readValue(this.jsonNode.toString(), jacksonClass));
    }

    public static JavaType constructCollectionType(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        return JsonNodeRawFlag.objectMapper().getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }

    @Override
    public JsonNode asJsonNode() {
        return this.jsonNode;
    }

    @Override
    public String asJson() {
        return this.jsonNode.toString();
    }

    public String toString() {
        return "JsonNodeRawFlag{jsonNode=" + String.valueOf(this.jsonNode) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonNodeRawFlag that = (JsonNodeRawFlag)o;
        return this.jsonNode.equals((Object)that.jsonNode);
    }

    public int hashCode() {
        return Objects.hash(this.jsonNode);
    }

    private static ObjectMapper objectMapper() {
        return mapper.updateAndGet(objectMapper -> {
            if (objectMapper != null) {
                return objectMapper;
            }
            return new ObjectMapper();
        });
    }
}

