/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SidecarQuota {
    private final Double cpu;
    private final Double memoryGiB;
    private final String gpu;

    @JsonCreator
    public SidecarQuota(@JsonProperty(value="cpu") Double cpu, @JsonProperty(value="memory") Double memoryGiB, @JsonProperty(value="gpu") String gpu) {
        this.cpu = cpu;
        this.memoryGiB = memoryGiB;
        this.gpu = gpu;
    }

    @JsonGetter(value="cpu")
    public Double getCpu() {
        return this.cpu;
    }

    @JsonGetter(value="memoryGiB")
    public Double getMemoryGiB() {
        return this.memoryGiB;
    }

    @JsonGetter(value="gpu")
    public String getGpu() {
        return this.gpu;
    }

    public String toString() {
        return "SidecarQuota{cpus=%s, memoryGiB=%s, gpu='%s'}".formatted(Optional.ofNullable(this.cpu).map(Object::toString).orElse("null"), Optional.ofNullable(this.memoryGiB).map(Object::toString).orElse("null"), String.valueOf(this.gpu));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidecarQuota that = (SidecarQuota)o;
        return Objects.equals(this.cpu, that.cpu) && Objects.equals(this.memoryGiB, that.memoryGiB) && Objects.equals(this.gpu, that.gpu);
    }

    public int hashCode() {
        return Objects.hash(this.cpu, this.memoryGiB, this.gpu);
    }
}

