/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.vespa.flags.custom.SidecarQuota;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Sidecar {
    private final String name;
    private final String image;
    private final SidecarQuota quota;
    private final List<String> volumeMounts;
    private final Map<String, String> envs;
    private final List<String> command;

    @JsonCreator
    public Sidecar(@JsonProperty(value="name") String name, @JsonProperty(value="image") String image, @JsonProperty(value="quota") SidecarQuota quota, @JsonProperty(value="volumeMounts") List<String> volumeMounts, @JsonProperty(value="envs") Map<String, String> envs, @JsonProperty(value="command") List<String> command) {
        this.name = name;
        this.image = image;
        this.quota = quota;
        this.volumeMounts = volumeMounts;
        this.envs = envs;
        this.command = command;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="image")
    public String getImage() {
        return this.image;
    }

    @JsonGetter(value="quota")
    public SidecarQuota getQuota() {
        return this.quota;
    }

    @JsonGetter(value="volumeMounts")
    public List<String> getVolumeMounts() {
        return this.volumeMounts;
    }

    @JsonGetter(value="envs")
    public Map<String, String> getEnvs() {
        return this.envs;
    }

    @JsonGetter(value="command")
    public List<String> getCommand() {
        return this.command;
    }

    public String toString() {
        return "Sidecar{name='%s', image='%s', quota=%s, volumeMounts={%s}, envs=[%s], command=[%s]}".formatted(this.name, this.image, this.quota, this.volumeMounts.stream().map(arg_0 -> Sidecar.lambda$toString$0("'%s'", arg_0)).collect(Collectors.joining(", ")), this.envs.entrySet().stream().map(entry -> "%s='%s'".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")), this.command.stream().map(arg_0 -> Sidecar.lambda$toString$2("'%s'", arg_0)).collect(Collectors.joining(", ")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sidecar that = (Sidecar)o;
        return Objects.equals(this.image, that.image) && Objects.equals(this.quota, that.quota) && Objects.equals(this.volumeMounts, that.volumeMounts) && Objects.equals(this.envs, that.envs) && Objects.equals(this.command, that.command);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.quota);
    }

    private static /* synthetic */ String lambda$toString$2(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$toString$0(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }
}

