/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.vespa.flags.custom.Validation;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostResources {
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final double bandwidthGbps;
    private final String diskSpeed;
    private final String storageType;
    private final Optional<String> clusterType;
    private final int containers;
    private final String architecture;

    @JsonCreator
    public HostResources(@JsonProperty(value="vcpu") Double vcpu, @JsonProperty(value="memoryGb") Double memoryGb, @JsonProperty(value="diskGb") Double diskGb, @JsonProperty(value="bandwidthGbps") Double bandwidthGbps, @JsonProperty(value="diskSpeed") String diskSpeed, @JsonProperty(value="storageType") String storageType, @JsonProperty(value="clusterType") String clusterType, @JsonProperty(value="containers") Integer containers, @JsonProperty(value="architecture") String architecture) {
        this.vcpu = Validation.requirePositive("vcpu", vcpu);
        this.memoryGb = Validation.requirePositive("memoryGb", memoryGb);
        this.diskGb = Validation.requirePositive("diskGb", diskGb);
        this.bandwidthGbps = Validation.requirePositive("bandwidthGbps", bandwidthGbps);
        this.diskSpeed = Validation.validateEnum("diskSpeed", Validation.validDiskSpeeds, diskSpeed);
        this.storageType = Validation.validateEnum("storageType", Validation.validStorageTypes, storageType);
        this.clusterType = Optional.ofNullable(clusterType).map(cType -> Validation.validateEnum("clusterType", Validation.validClusterTypes, cType));
        this.containers = Validation.requirePositive("containers", containers);
        this.architecture = Validation.validateEnum("architecture", Validation.validArchitectures, architecture);
    }

    @JsonProperty(value="vcpu")
    public double vcpu() {
        return this.vcpu;
    }

    @JsonProperty(value="memoryGb")
    public double memoryGb() {
        return this.memoryGb;
    }

    @JsonProperty(value="diskGb")
    public double diskGb() {
        return this.diskGb;
    }

    @JsonProperty(value="bandwidthGbps")
    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    @JsonProperty(value="diskSpeed")
    public String diskSpeed() {
        return this.diskSpeed;
    }

    @JsonProperty(value="storageType")
    public String storageType() {
        return this.storageType;
    }

    @JsonProperty(value="clusterType")
    public String clusterTypeOrNull() {
        return this.clusterType.orElse(null);
    }

    @JsonIgnore
    public Optional<String> clusterType() {
        return this.clusterType;
    }

    @JsonProperty(value="containers")
    public int containers() {
        return this.containers;
    }

    @JsonProperty(value="architecture")
    public String architecture() {
        return this.architecture;
    }

    public boolean satisfiesClusterType(String clusterType) {
        return this.clusterType.map(clusterType::equalsIgnoreCase).orElse(true);
    }

    public String toString() {
        return "HostResources{vcpu=" + this.vcpu + ", memoryGb=" + this.memoryGb + ", diskGb=" + this.diskGb + ", bandwidthGbps=" + this.bandwidthGbps + ", diskSpeed='" + this.diskSpeed + "', storageType='" + this.storageType + "', clusterType='" + String.valueOf(this.clusterType) + "', containers=" + this.containers + ", architecture=" + this.architecture + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostResources resources = (HostResources)o;
        return Double.compare(resources.vcpu, this.vcpu) == 0 && Double.compare(resources.memoryGb, this.memoryGb) == 0 && Double.compare(resources.diskGb, this.diskGb) == 0 && Double.compare(resources.bandwidthGbps, this.bandwidthGbps) == 0 && this.diskSpeed.equals(resources.diskSpeed) && this.storageType.equals(resources.storageType) && this.clusterType.equals(resources.clusterType) && this.containers == resources.containers && this.architecture.equals(resources.architecture);
    }

    public int hashCode() {
        return Objects.hash(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.clusterType, this.containers, this.architecture);
    }
}

