/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import java.util.Objects;
import java.util.Set;

public class Validation {
    static final Set<String> validDiskSpeeds = Set.of("slow", "fast", "any");
    static final Set<String> validStorageTypes = Set.of("remote", "local", "any");
    static final Set<String> validClusterTypes = Set.of("container", "content", "combined", "admin");
    static final Set<String> validArchitectures = Set.of("arm64", "x86_64", "any");

    static double requirePositive(String name, Double value) {
        Validation.requireNonNull(name, value);
        if (value <= 0.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    static int requirePositive(String name, Integer value) {
        Validation.requireNonNull(name, value);
        if (value <= 0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    static double requireNonNegative(String name, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    static String validateEnum(String name, Set<String> validValues, String value) {
        Validation.requireNonNull(name, value);
        if (!validValues.contains(value)) {
            throw new IllegalArgumentException("Invalid " + name + ", valid values are: " + String.valueOf(validValues) + ", got: " + value);
        }
        return value;
    }

    private static <T> T requireNonNull(String name, T value) {
        return Objects.requireNonNull(value, () -> "'" + name + "' has not been specified");
    }
}

