/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.component.Version;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.json.Condition;
import com.yahoo.vespa.flags.json.RelationalPredicate;
import com.yahoo.vespa.flags.json.wire.WireCondition;
import java.util.Objects;
import java.util.function.Predicate;

public class RelationalCondition
implements Condition {
    private final RelationalPredicate relationalPredicate;
    private final Predicate<String> predicate;
    private final Dimension dimension;

    public static RelationalCondition create(Condition.CreateParams params) {
        if (!params.values().isEmpty()) {
            throw new IllegalArgumentException(RelationalCondition.class.getSimpleName() + " does not support the 'values' field");
        }
        String predicate = params.predicate().orElseThrow(() -> new IllegalArgumentException(RelationalCondition.class.getSimpleName() + " requires the predicate field in the condition"));
        RelationalPredicate relationalPredicate = RelationalPredicate.fromWire(predicate);
        switch (params.dimension()) {
            case VESPA_VERSION: {
                Version rightVersion = Version.fromString((String)relationalPredicate.rightOperand());
                Predicate<String> p = leftString -> {
                    Version leftVersion = Version.fromString((String)leftString);
                    return relationalPredicate.operator().evaluate(leftVersion, rightVersion);
                };
                return new RelationalCondition(relationalPredicate, p, params.dimension());
            }
        }
        throw new IllegalArgumentException(RelationalCondition.class.getSimpleName() + " not supported for dimension " + Dimension.VESPA_VERSION.name());
    }

    private RelationalCondition(RelationalPredicate relationalPredicate, Predicate<String> predicate, Dimension dimension) {
        this.relationalPredicate = relationalPredicate;
        this.predicate = predicate;
        this.dimension = dimension;
    }

    @Override
    public Condition.Type type() {
        return Condition.Type.RELATIONAL;
    }

    @Override
    public Dimension dimension() {
        return this.dimension;
    }

    @Override
    public Condition.CreateParams toCreateParams() {
        return new Condition.CreateParams(this.dimension).withPredicate(this.relationalPredicate.toWire());
    }

    @Override
    public boolean test(FetchVector fetchVector) {
        return fetchVector.getValue(this.dimension).map(this.predicate::test).orElse(false);
    }

    public RelationalPredicate relationalPredicate() {
        return this.relationalPredicate;
    }

    @Override
    public WireCondition toWire() {
        WireCondition condition = new WireCondition();
        condition.type = Condition.Type.RELATIONAL.toWire();
        condition.dimension = this.dimension.toWire();
        condition.predicate = this.relationalPredicate.toWire();
        return condition;
    }

    public String toString() {
        return "RelationalCondition{relationalPredicate=" + this.relationalPredicate + ", predicate=" + this.predicate + ", dimension=" + this.dimension + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationalCondition that = (RelationalCondition)o;
        return this.relationalPredicate.equals(that.relationalPredicate) && this.predicate.equals(that.predicate) && this.dimension == that.dimension;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relationalPredicate, this.predicate, this.dimension});
    }
}

