/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.vespa.flags.Deserializer;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.RawFlag;
import com.yahoo.vespa.flags.json.FetchVectorHelper;
import com.yahoo.vespa.flags.json.Rule;
import com.yahoo.vespa.flags.json.wire.WireFlagData;
import com.yahoo.vespa.flags.json.wire.WireFlagDataList;
import com.yahoo.vespa.flags.json.wire.WireRule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class FlagData {
    private final FlagId id;
    private final List<Rule> rules;
    private final FetchVector defaultFetchVector;

    public FlagData(FlagId id) {
        this(id, new FetchVector(), List.of());
    }

    public FlagData(FlagId id, FetchVector defaultFetchVector, Rule ... rules) {
        this(id, defaultFetchVector, List.of(rules));
    }

    public FlagData(FlagId id, FetchVector defaultFetchVector, List<Rule> rules) {
        this.id = id;
        this.rules = List.copyOf(rules);
        this.defaultFetchVector = defaultFetchVector;
    }

    public FlagId id() {
        return this.id;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public boolean isEmpty() {
        return this.rules.isEmpty() && this.defaultFetchVector.isEmpty();
    }

    public FlagData partialResolve(FetchVector fetchVector) {
        List<Rule> newRules = new ArrayList<Rule>();
        for (Rule rule : this.rules) {
            Optional<Rule> partialRule = rule.partialResolve(fetchVector);
            if (!partialRule.isPresent()) continue;
            newRules.add(partialRule.get());
            if (!partialRule.get().conditions().isEmpty()) continue;
            break;
        }
        newRules = FlagData.optimizeRules(newRules);
        FetchVector newDefaultFetchVector = this.defaultFetchVector.without(fetchVector.dimensions());
        return new FlagData(this.id, newDefaultFetchVector, newRules);
    }

    public Optional<RawFlag> resolve(FetchVector fetchVector) {
        return this.rules.stream().filter(rule -> rule.match(this.defaultFetchVector.with(fetchVector))).findFirst().flatMap(Rule::getValueToApply);
    }

    public String serializeToJson() {
        return this.toWire().serializeToJson();
    }

    public byte[] serializeToUtf8Json() {
        return this.toWire().serializeToBytes();
    }

    public void serializeToOutputStream(OutputStream outputStream) {
        this.toWire().serializeToOutputStream(outputStream);
    }

    public JsonNode toJsonNode() {
        return this.toWire().serializeToJsonNode();
    }

    public WireFlagData toWire() {
        WireFlagData wireFlagData = new WireFlagData();
        wireFlagData.id = this.id.toString();
        if (!this.rules.isEmpty()) {
            wireFlagData.rules = this.rules.stream().map(Rule::toWire).toList();
        }
        wireFlagData.defaultFetchVector = FetchVectorHelper.toWire(this.defaultFetchVector);
        return wireFlagData;
    }

    public void validate(Deserializer<?> deserializer) {
        this.rules.stream().flatMap(rule -> rule.getValueToApply().map(Stream::of).orElse(null)).forEach(deserializer::deserialize);
    }

    public String toString() {
        return "FlagData{id=" + this.id + ", rules=" + this.rules + ", defaultFetchVector=" + this.defaultFetchVector + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagData flagData = (FlagData)o;
        return this.id.equals(flagData.id) && this.rules.equals(flagData.rules) && this.defaultFetchVector.equals(flagData.defaultFetchVector);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rules, this.defaultFetchVector);
    }

    public static FlagData deserializeUtf8Json(byte[] bytes) {
        return FlagData.fromWire(WireFlagData.deserialize(bytes));
    }

    public static FlagData deserialize(InputStream inputStream) {
        return FlagData.fromWire(WireFlagData.deserialize(inputStream));
    }

    public static FlagData deserialize(String string) {
        return FlagData.fromWire(WireFlagData.deserialize(string));
    }

    public static FlagData fromWire(WireFlagData wireFlagData) {
        if (wireFlagData.id == null) {
            throw new IllegalArgumentException("Flag ID missing");
        }
        return new FlagData(new FlagId(wireFlagData.id), FetchVectorHelper.fromWire(wireFlagData.defaultFetchVector), FlagData.rulesFromWire(wireFlagData.rules));
    }

    public static byte[] serializeListToUtf8Json(List<FlagData> list) {
        return FlagData.listToWire(list).serializeToBytes();
    }

    public static List<FlagData> deserializeList(byte[] bytes) {
        return FlagData.listFromWire(WireFlagDataList.deserializeFrom(bytes));
    }

    public static WireFlagDataList listToWire(List<FlagData> list) {
        WireFlagDataList wireList = new WireFlagDataList();
        wireList.flags = list.stream().map(FlagData::toWire).toList();
        return wireList;
    }

    public static List<FlagData> listFromWire(WireFlagDataList wireList) {
        return wireList.flags.stream().map(FlagData::fromWire).toList();
    }

    private static List<Rule> rulesFromWire(List<WireRule> wireRules) {
        if (wireRules == null) {
            return List.of();
        }
        return FlagData.optimizeRules(wireRules.stream().map(Rule::fromWire).toList());
    }

    private static List<Rule> optimizeRules(List<Rule> rules) {
        Rule lastRule;
        if (rules.isEmpty()) {
            return rules;
        }
        if (rules.get(rules.size() - 1).getValueToApply().isPresent()) {
            return rules;
        }
        ArrayList<Rule> newRules = new ArrayList<Rule>(rules);
        while (newRules.size() > 0 && (lastRule = newRules.get(newRules.size() - 1)).getValueToApply().isEmpty()) {
            newRules.remove(newRules.size() - 1);
        }
        return newRules;
    }
}

