/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.SimpleFlagSerializer;
import com.yahoo.vespa.flags.StringFlag;
import com.yahoo.vespa.flags.UnboundFlagImpl;
import java.util.function.Predicate;

public class UnboundStringFlag
extends UnboundFlagImpl<String, StringFlag, UnboundStringFlag> {
    public UnboundStringFlag(FlagId id, String defaultValue) {
        this(id, defaultValue, new FetchVector());
    }

    public UnboundStringFlag(FlagId id, String defaultValue, FetchVector defaultFetchVector) {
        this(id, defaultValue, defaultFetchVector, new SimpleFlagSerializer<String>(TextNode::new, JsonNode::isTextual, JsonNode::asText));
    }

    public UnboundStringFlag(FlagId id, String defaultValue, Predicate<String> validator) {
        this(id, defaultValue, new FetchVector(), validator);
    }

    public UnboundStringFlag(FlagId id, String defaultValue, FetchVector fetchVector, Predicate<String> validator) {
        this(id, defaultValue, fetchVector, new SimpleFlagSerializer<String>(TextNode::new, JsonNode::isTextual, jsonNode -> {
            if (!validator.test(jsonNode.asText())) {
                throw new IllegalArgumentException("Invalid value: '" + jsonNode.asText() + "'");
            }
            return jsonNode.asText();
        }));
    }

    public UnboundStringFlag(FlagId id, String defaultValue, FetchVector defaultFetchVector, FlagSerializer<String> serializer) {
        super(id, defaultValue, defaultFetchVector, serializer, UnboundStringFlag::new, StringFlag::new);
    }
}

