/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.json.BlacklistCondition;
import com.yahoo.vespa.flags.json.RelationalCondition;
import com.yahoo.vespa.flags.json.WhitelistCondition;
import com.yahoo.vespa.flags.json.wire.WireCondition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public interface Condition
extends Predicate<FetchVector> {
    public static Condition fromWire(WireCondition wireCondition) {
        Objects.requireNonNull(wireCondition.type);
        Type type = Type.fromWire(wireCondition.type);
        Objects.requireNonNull(wireCondition.dimension);
        Dimension dimension = Dimension.fromWire(wireCondition.dimension);
        CreateParams params = new CreateParams(dimension);
        if (wireCondition.values != null) {
            params.withValues(wireCondition.values);
        }
        if (wireCondition.predicate != null) {
            params.withPredicate(wireCondition.predicate);
        }
        return params.createAs(type);
    }

    public Type type();

    public Dimension dimension();

    public CreateParams toCreateParams();

    public WireCondition toWire();

    public static enum Type {
        WHITELIST,
        BLACKLIST,
        RELATIONAL;


        public String toWire() {
            return this.name().toLowerCase();
        }

        public static Type fromWire(String typeString) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(typeString)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown type: '" + typeString + "'");
        }
    }

    public static class CreateParams {
        private final Dimension dimension;
        private List<String> values = List.of();
        private Optional<String> predicate = Optional.empty();

        public CreateParams(Dimension dimension) {
            this.dimension = Objects.requireNonNull(dimension);
        }

        public CreateParams withValues(String ... values) {
            return this.withValues(List.of(values));
        }

        public CreateParams withValues(List<String> values) {
            this.values = List.copyOf(values);
            return this;
        }

        public CreateParams withPredicate(String predicate) {
            this.predicate = Optional.of(predicate);
            return this;
        }

        public Dimension dimension() {
            return this.dimension;
        }

        public List<String> values() {
            return this.values;
        }

        public Optional<String> predicate() {
            return this.predicate;
        }

        public Condition createAs(Type type) {
            switch (type) {
                case WHITELIST: {
                    return WhitelistCondition.create(this);
                }
                case BLACKLIST: {
                    return BlacklistCondition.create(this);
                }
                case RELATIONAL: {
                    return RelationalCondition.create(this);
                }
            }
            throw new IllegalArgumentException("Unknown type '" + type + "'");
        }
    }
}

