/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.json.FetchVectorHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class DimensionHelper {
    private static final Map<FetchVector.Dimension, String> serializedDimensions = new HashMap<FetchVector.Dimension, String>();
    private static final Map<String, FetchVector.Dimension> deserializedDimensions;

    public static String toWire(FetchVector.Dimension dimension) {
        String serializedDimension = serializedDimensions.get((Object)dimension);
        if (serializedDimension == null) {
            throw new IllegalArgumentException("Unsupported dimension (please add it): '" + dimension + "'");
        }
        return serializedDimension;
    }

    public static FetchVector.Dimension fromWire(String serializedDimension) {
        FetchVector.Dimension dimension = deserializedDimensions.get(serializedDimension);
        if (dimension == null) {
            throw new IllegalArgumentException("Unknown serialized dimension: '" + serializedDimension + "'");
        }
        return dimension;
    }

    private DimensionHelper() {
    }

    static {
        serializedDimensions.put(FetchVector.Dimension.APPLICATION_ID, "application");
        serializedDimensions.put(FetchVector.Dimension.CLOUD, "cloud");
        serializedDimensions.put(FetchVector.Dimension.CLUSTER_ID, "cluster-id");
        serializedDimensions.put(FetchVector.Dimension.CLUSTER_TYPE, "cluster-type");
        serializedDimensions.put(FetchVector.Dimension.CONSOLE_USER_EMAIL, "console-user-email");
        serializedDimensions.put(FetchVector.Dimension.ENVIRONMENT, "environment");
        serializedDimensions.put(FetchVector.Dimension.HOSTNAME, "hostname");
        serializedDimensions.put(FetchVector.Dimension.NODE_TYPE, "node-type");
        serializedDimensions.put(FetchVector.Dimension.SYSTEM, "system");
        serializedDimensions.put(FetchVector.Dimension.TENANT_ID, "tenant");
        serializedDimensions.put(FetchVector.Dimension.VESPA_VERSION, "vespa-version");
        serializedDimensions.put(FetchVector.Dimension.ZONE_ID, "zone");
        if (serializedDimensions.size() != FetchVector.Dimension.values().length) {
            throw new IllegalStateException(FetchVectorHelper.class.getName() + " is not in sync with " + FetchVector.Dimension.class.getName());
        }
        deserializedDimensions = serializedDimensions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

