/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.vespa.flags.Deserializer;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.RawFlag;
import com.yahoo.vespa.flags.json.FetchVectorHelper;
import com.yahoo.vespa.flags.json.Rule;
import com.yahoo.vespa.flags.json.wire.WireFlagData;
import com.yahoo.vespa.flags.json.wire.WireFlagDataList;
import com.yahoo.vespa.flags.json.wire.WireRule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FlagData {
    private final FlagId id;
    private final List<Rule> rules;
    private final FetchVector defaultFetchVector;

    public FlagData(FlagId id) {
        this(id, new FetchVector(), Collections.emptyList());
    }

    public FlagData(FlagId id, FetchVector defaultFetchVector, Rule ... rules) {
        this(id, defaultFetchVector, Arrays.asList(rules));
    }

    public FlagData(FlagId id, FetchVector defaultFetchVector, List<Rule> rules) {
        this.id = id;
        this.rules = Collections.unmodifiableList(new ArrayList<Rule>(rules));
        this.defaultFetchVector = defaultFetchVector;
    }

    public FlagId id() {
        return this.id;
    }

    public Optional<RawFlag> resolve(FetchVector fetchVector) {
        return this.rules.stream().filter(rule -> rule.match(this.defaultFetchVector.with(fetchVector))).findFirst().flatMap(Rule::getValueToApply);
    }

    public String serializeToJson() {
        return this.toWire().serializeToJson();
    }

    public byte[] serializeToUtf8Json() {
        return this.toWire().serializeToBytes();
    }

    public void serializeToOutputStream(OutputStream outputStream) {
        this.toWire().serializeToOutputStream(outputStream);
    }

    public JsonNode toJsonNode() {
        return this.toWire().serializeToJsonNode();
    }

    public WireFlagData toWire() {
        WireFlagData wireFlagData = new WireFlagData();
        wireFlagData.id = this.id.toString();
        if (!this.rules.isEmpty()) {
            wireFlagData.rules = this.rules.stream().map(Rule::toWire).collect(Collectors.toList());
        }
        wireFlagData.defaultFetchVector = FetchVectorHelper.toWire(this.defaultFetchVector);
        return wireFlagData;
    }

    public static FlagData deserializeUtf8Json(byte[] bytes) {
        return FlagData.fromWire(WireFlagData.deserialize(bytes));
    }

    public static FlagData deserialize(InputStream inputStream) {
        return FlagData.fromWire(WireFlagData.deserialize(inputStream));
    }

    public static FlagData deserialize(String string) {
        return FlagData.fromWire(WireFlagData.deserialize(string));
    }

    public static FlagData fromWire(WireFlagData wireFlagData) {
        if (wireFlagData.id == null) {
            throw new IllegalArgumentException("Flag ID missing");
        }
        return new FlagData(new FlagId(wireFlagData.id), FetchVectorHelper.fromWire(wireFlagData.defaultFetchVector), FlagData.rulesFromWire(wireFlagData.rules));
    }

    public static byte[] serializeListToUtf8Json(List<FlagData> list) {
        return FlagData.listToWire(list).serializeToBytes();
    }

    public static List<FlagData> deserializeList(byte[] bytes) {
        return FlagData.listFromWire(WireFlagDataList.deserializeFrom(bytes));
    }

    public static WireFlagDataList listToWire(List<FlagData> list) {
        WireFlagDataList wireList = new WireFlagDataList();
        wireList.flags = list.stream().map(FlagData::toWire).collect(Collectors.toList());
        return wireList;
    }

    public static List<FlagData> listFromWire(WireFlagDataList wireList) {
        return wireList.flags.stream().map(FlagData::fromWire).collect(Collectors.toList());
    }

    private static List<Rule> rulesFromWire(List<WireRule> wireRules) {
        if (wireRules == null) {
            return Collections.emptyList();
        }
        return wireRules.stream().map(Rule::fromWire).collect(Collectors.toList());
    }

    public void validate(Deserializer<?> deserializer) {
        this.rules.stream().flatMap(rule -> rule.getValueToApply().map(Stream::of).orElse(null)).forEach(deserializer::deserialize);
    }
}

