/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.UnboundFlag;

public abstract class UnboundFlagImpl<T, F extends Flag<T, F>, U extends UnboundFlag<T, F, U>>
implements UnboundFlag<T, F, U> {
    private final FlagId id;
    private final T defaultValue;
    private final FlagSerializer<T> serializer;
    private final FetchVector defaultFetchVector;
    private final UnboundFlagFactory<T, F, U> unboundFlagFactory;
    private final FlagFactory<T, F> flagFactory;

    protected UnboundFlagImpl(FlagId id, T defaultValue, FetchVector defaultFetchVector, FlagSerializer<T> serializer, UnboundFlagFactory<T, F, U> unboundFlagFactory, FlagFactory<T, F> flagFactory) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.serializer = serializer;
        this.defaultFetchVector = defaultFetchVector;
        this.unboundFlagFactory = unboundFlagFactory;
        this.flagFactory = flagFactory;
    }

    @Override
    public FlagId id() {
        return this.id;
    }

    @Override
    public U with(FetchVector.Dimension dimension, String dimensionValue) {
        return this.unboundFlagFactory.create(this.id, this.defaultValue, this.defaultFetchVector.with(dimension, dimensionValue));
    }

    @Override
    public F bindTo(FlagSource source) {
        return this.flagFactory.create(this.id, this.defaultValue, this.defaultFetchVector, this.serializer, source);
    }

    @Override
    public FlagSerializer<T> serializer() {
        return this.serializer;
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }

    public static interface FlagFactory<T2, F2 extends Flag<T2, F2>> {
        public F2 create(FlagId var1, T2 var2, FetchVector var3, FlagSerializer<T2> var4, FlagSource var5);
    }

    public static interface UnboundFlagFactory<T1, F1 extends Flag<T1, F1>, U1 extends UnboundFlag<T1, F1, U1>> {
        public U1 create(FlagId var1, T1 var2, FetchVector var3);
    }
}

