/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, List.of("baldersheim"), "2020-12-02", "2022-01-01", "Default limit for when to apply termwise query evaluation", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag FEED_SEQUENCER_TYPE = Flags.defineStringFlag("feed-sequencer-type", "LATENCY", List.of("baldersheim"), "2020-12-02", "2022-01-01", "Selects type of sequenced executor used for feeding, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("baldersheim"), "2020-12-02", "2022-01-01", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("baldersheim"), "2020-12-02", "2022-01-01", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_COMMUNICATIONMANAGER_THREAD = Flags.defineFeatureFlag("skip-communicatiomanager-thread", false, List.of("baldersheim"), "2020-12-02", "2022-01-01", "Should we skip the communicationmanager thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REQUEST_THREAD = Flags.defineFeatureFlag("skip-mbus-request-thread", false, List.of("baldersheim"), "2020-12-02", "2022-01-01", "Should we skip the mbus request thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REPLY_THREAD = Flags.defineFeatureFlag("skip-mbus-reply-thread", false, List.of("baldersheim"), "2020-12-02", "2022-01-01", "Should we skip the mbus reply thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_THREE_PHASE_UPDATES = Flags.defineFeatureFlag("use-three-phase-updates", false, List.of("vekterli"), "2020-12-02", "2021-08-01", "Whether to enable the use of three-phase updates when bucket replicas are out of sync.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag TENANT_IAM_ROLE = Flags.defineFeatureFlag("application-iam-roles", false, List.of("tokle"), "2020-12-02", "2021-08-01", "Allow separate iam roles when provisioning/assigning hosts", "Takes effect immediately on new hosts, on next redeploy for applications", FetchVector.Dimension.TENANT_ID);
    public static final UnboundBooleanFlag HIDE_SHARED_ROUTING_ENDPOINT = Flags.defineFeatureFlag("hide-shared-routing-endpoint", false, List.of("tokle", "bjormel"), "2020-12-02", "2021-09-01", "Whether the controller should hide shared routing layer endpoint", "Takes effect immediately", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", false, List.of("baldersheim"), "2020-12-02", "2022-01-01", "Optionally deliver async messages in own thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag FEED_CONCURRENCY = Flags.defineDoubleFlag("feed-concurrency", 0.5, List.of("baldersheim"), "2020-12-02", "2022-01-01", "How much concurrency should be allowed for feed", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag GROUP_SUSPENSION = Flags.defineFeatureFlag("group-suspension", true, List.of("hakon"), "2021-01-22", "2021-06-22", "Allow all content nodes in a hierarchical group to suspend at the same time", "Takes effect on the next suspension request to the Orchestrator.", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENCRYPT_DISK = Flags.defineFeatureFlag("encrypt-disk", false, List.of("hakonhall"), "2021-05-05", "2021-08-05", "Allow migrating an unencrypted data partition to being encrypted.", "Takes effect on next host-admin tick.", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag ENCRYPT_DIRTY_DISK = Flags.defineFeatureFlag("encrypt-dirty-disk", false, List.of("hakonhall"), "2021-05-14", "2021-08-05", "Allow migrating an unencrypted data partition to being encrypted when (de)provisioned.", "Takes effect on next host-admin tick.", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag ENABLE_FEED_BLOCK_IN_DISTRIBUTOR = Flags.defineFeatureFlag("enable-feed-block-in-distributor", true, List.of("geirst"), "2021-01-27", "2021-07-01", "Enables blocking of feed in the distributor if resource usage is above limit on at least one content node", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag METRICS_PROXY_MAX_HEAP_SIZE_IN_MB = Flags.defineIntFlag("metrics-proxy-max-heap-size-in-mb", 256, List.of("hmusum"), "2021-03-01", "2021-07-01", "JVM max heap size for metrics proxy in Mb", "Takes effect when restarting metrics proxy", FetchVector.Dimension.CLUSTER_TYPE);
    public static final UnboundStringFlag DEDICATED_CLUSTER_CONTROLLER_FLAVOR = Flags.defineStringFlag("dedicated-cluster-controller-flavor", "", List.of("jonmv"), "2021-02-25", "2021-08-25", "Flavor as <vpu>-<memgb>-<diskgb> to use for dedicated cluster controller nodes", "Takes effect immediately, for subsequent provisioning", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundListFlag<String> ALLOWED_ATHENZ_PROXY_IDENTITIES = Flags.defineListFlag("allowed-athenz-proxy-identities", List.of(), String.class, List.of("bjorncs", "tokle"), "2021-02-10", "2021-08-01", "Allowed Athenz proxy identities", "takes effect at redeployment", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag GENERATE_NON_MTLS_ENDPOINT = Flags.defineFeatureFlag("generate-non-mtls-endpoint", true, List.of("tokle"), "2021-02-18", "2021-10-01", "Whether to generate the non-mtls endpoint", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS = Flags.defineIntFlag("max-activation-inhibited-out-of-sync-groups", 0, List.of("vekterli"), "2021-02-19", "2021-07-01", "Allows replicas in up to N content groups to not be activated for query visibility if they are out of sync with a majority of other replicas", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_CUSTOM_ACL_MAPPING = Flags.defineFeatureFlag("enable-custom-acl-mapping", false, List.of("mortent", "bjorncs"), "2021-04-13", "2021-08-01", "Whether access control filters should read acl request mapping from handler or use default", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag NUM_DISTRIBUTOR_STRIPES = Flags.defineIntFlag("num-distributor-stripes", 0, List.of("geirst", "vekterli"), "2021-04-20", "2021-07-01", "Specifies the number of stripes used by the distributor. When 0, legacy single stripe behavior is used.", "Takes effect after distributor restart", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_CONCURRENT_MERGES_PER_NODE = Flags.defineIntFlag("max-concurrent-merges-per-node", 16, List.of("balder", "vekterli"), "2021-06-06", "2021-08-01", "Specifies max concurrent merges per content node.", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_MERGE_QUEUE_SIZE = Flags.defineIntFlag("max-merge-queue-size", 1024, List.of("balder", "vekterli"), "2021-06-06", "2021-08-01", "Specifies max size of merge queue.", "Takes effect at redeploy", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_EXTERNAL_RANK_EXPRESSION = Flags.defineFeatureFlag("use-external-rank-expression", false, List.of("baldersheim"), "2021-05-24", "2021-07-01", "Whether to use distributed external rank expression or inline in rankproperties", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag DISTRIBUTE_EXTERNAL_RANK_EXPRESSION = Flags.defineFeatureFlag("distribute-external-rank-expression", false, List.of("baldersheim"), "2021-05-27", "2021-07-01", "Whether to use distributed external rank expression files by filedistribution", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag LARGE_RANK_EXPRESSION_LIMIT = Flags.defineIntFlag("large-rank-expression-limit", 65536, List.of("baldersheim"), "2021-06-09", "2021-07-01", "Limit for size of rank expressions distributed by filedistribution", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_ROUTING_CORE_DUMP = Flags.defineFeatureFlag("enable-routing-core-dumps", false, List.of("tokle"), "2021-04-16", "2021-08-01", "Whether to enable core dumps for routing layer", "Takes effect on next host-admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag CFG_DEPLOY_MULTIPART = Flags.defineFeatureFlag("cfg-deploy-multipart", false, List.of("tokle"), "2021-05-19", "2021-08-01", "Whether to deploy applications using multipart form data (instead of url params)", "Takes effect immediately", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_ENCRYPTING_HOSTS = Flags.defineIntFlag("max-encrypting-hosts", 0, List.of("mpolden", "hakonhall"), "2021-05-27", "2021-10-01", "The maximum number of hosts allowed to encrypt their disk concurrently", "Takes effect on next run of HostEncrypter, but any currently encrypting hosts will not be cancelled when reducing the limit", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag REQUIRE_CONNECTIVITY_CHECK = Flags.defineFeatureFlag("require-connectivity-check", false, List.of("arnej"), "2021-06-03", "2021-09-01", "Require that config-sentinel connectivity check passes with good quality before starting services", "Takes effect on next restart", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag THROW_EXCEPTION_IF_RESOURCE_LIMITS_SPECIFIED = Flags.defineFeatureFlag("throw-exception-if-resource-limits-specified", false, List.of("hmusum"), "2021-06-07", "2021-08-07", "Whether to throw an exception in hosted Vespa if the application specifies resource limits in services.xml", "Takes effect on next deployment through controller", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag MOVE_SEARCH_DEFINITIONS_TO_SCHEMAS_DIR = Flags.defineFeatureFlag("move-search-definitions-to-schemas-dir", false, List.of("hmusum"), "2021-06-09", "2021-08-09", "Whether to move files in searchdefinitions/ to schemas/ when deploying an application", "Takes effect on next deployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag LOAD_LOCAL_SESSIONS_WHEN_BOOTSTRAPPING = Flags.defineFeatureFlag("load-local-sessions-when-bootstrapping", true, List.of("hmusum"), "2021-06-15", "2021-07-15", "Whether to load local sessions when bootstrapping config server", "Takes effect on restart of config server", new FetchVector.Dimension[0]);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(FetchVector.Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

