/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.OptionalDouble;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClusterCapacity {
    private final int count;
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final OptionalDouble bandwidthGbps;

    @JsonCreator
    public ClusterCapacity(@JsonProperty(value="count") int count, @JsonProperty(value="vcpu") double vcpu, @JsonProperty(value="memoryGb") double memoryGb, @JsonProperty(value="diskGb") double diskGb, @JsonProperty(value="bandwidthGbps") Double bandwidthGbps) {
        this.count = (int)ClusterCapacity.requireNonNegative("count", count);
        this.vcpu = ClusterCapacity.requireNonNegative("vcpu", vcpu);
        this.memoryGb = ClusterCapacity.requireNonNegative("memoryGb", memoryGb);
        this.diskGb = ClusterCapacity.requireNonNegative("diskGb", diskGb);
        this.bandwidthGbps = bandwidthGbps == null ? OptionalDouble.empty() : OptionalDouble.of(bandwidthGbps);
    }

    public ClusterCapacity withCount(int count) {
        return new ClusterCapacity(count, this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbpsOrNull());
    }

    @JsonGetter(value="count")
    public int count() {
        return this.count;
    }

    @JsonGetter(value="vcpu")
    public double vcpu() {
        return this.vcpu;
    }

    @JsonGetter(value="memoryGb")
    public double memoryGb() {
        return this.memoryGb;
    }

    @JsonGetter(value="diskGb")
    public double diskGb() {
        return this.diskGb;
    }

    @JsonGetter(value="bandwidthGbps")
    public Double bandwidthGbpsOrNull() {
        return this.bandwidthGbps.isPresent() ? Double.valueOf(this.bandwidthGbps.getAsDouble()) : null;
    }

    @JsonIgnore
    public double bandwidthGbps() {
        return this.bandwidthGbps.orElse(1.0);
    }

    public String toString() {
        return "ClusterCapacity{count=" + this.count + ", vcpu=" + this.vcpu + ", memoryGb=" + this.memoryGb + ", diskGb=" + this.diskGb + ", bandwidthGbps=" + this.bandwidthGbps + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterCapacity that = (ClusterCapacity)o;
        return this.count == that.count && Double.compare(that.vcpu, this.vcpu) == 0 && Double.compare(that.memoryGb, this.memoryGb) == 0 && Double.compare(that.diskGb, this.diskGb) == 0 && this.bandwidthGbps.equals(that.bandwidthGbps);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps);
    }

    private static double requireNonNegative(String name, double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }
}

