/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.fasterxml.jackson.databind.JavaType;
import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;
import java.util.List;

public class JacksonArraySerializer<T>
implements FlagSerializer<List<T>> {
    private final JavaType type;

    public JacksonArraySerializer(Class<T> clazz) {
        this.type = JsonNodeRawFlag.constructCollectionType(List.class, clazz);
    }

    @Override
    public List<T> deserialize(RawFlag rawFlag) {
        return (List)JsonNodeRawFlag.fromJsonNode(rawFlag.asJsonNode()).toJacksonClass(this.type);
    }

    @Override
    public RawFlag serialize(List<T> value) {
        return JsonNodeRawFlag.fromJacksonClass(value);
    }
}

