/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundBooleanFlag RETIRE_WITH_PERMANENTLY_DOWN = Flags.defineFeatureFlag("retire-with-permanently-down", false, List.of("hakonhall"), "2020-12-02", "2021-02-01", "If enabled, retirement will end with setting the host status to PERMANENTLY_DOWN, instead of ALLOWED_TO_BE_DOWN (old behavior).", "Takes effect on the next run of RetiredExpirer.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Default limit for when to apply termwise query evaluation", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag FEED_SEQUENCER_TYPE = Flags.defineStringFlag("feed-sequencer-type", "LATENCY", List.of("baldersheim"), "2020-12-02", "2021-02-01", "Selects type of sequenced executor used for feeding, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("baldersheim"), "2020-12-02", "2021-02-01", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_COMMUNICATIONMANAGER_THREAD = Flags.defineFeatureFlag("skip-communicatiomanager-thread", false, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Should we skip the communicationmanager thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REQUEST_THREAD = Flags.defineFeatureFlag("skip-mbus-request-thread", false, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Should we skip the mbus request thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag SKIP_MBUS_REPLY_THREAD = Flags.defineFeatureFlag("skip-mbus-reply-thread", false, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Should we skip the mbus reply thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_THREE_PHASE_UPDATES = Flags.defineFeatureFlag("use-three-phase-updates", false, List.of("vekterli"), "2020-12-02", "2021-02-01", "Whether to enable the use of three-phase updates when bucket replicas are out of sync.", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_DIRECT_STORAGE_API_RPC = Flags.defineFeatureFlag("use-direct-storage-api-rpc", false, List.of("geirst"), "2020-12-02", "2021-02-01", "Whether to use direct RPC for Storage API communication between content cluster nodes.", "Takes effect at restart of distributor and content node process", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_FAST_VALUE_TENSOR_IMPLEMENTATION = Flags.defineFeatureFlag("use-fast-value-tensor-implementation", false, List.of("geirst"), "2020-12-02", "2021-02-01", "Whether to use FastValueBuilderFactory as the tensor implementation on all content nodes.", "Takes effect at restart of content node process", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag HOST_HARDENING = Flags.defineFeatureFlag("host-hardening", false, List.of("hakonhall"), "2020-12-02", "2021-02-01", "Whether to enable host hardening Linux baseline.", "Takes effect on next tick or on host-admin restart (may vary where used).", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag TCP_ABORT_ON_OVERFLOW = Flags.defineFeatureFlag("tcp-abort-on-overflow", false, List.of("andreer"), "2020-12-02", "2021-02-01", "Whether to set /proc/sys/net/ipv4/tcp_abort_on_overflow to 0 (false) or 1 (true)", "Takes effect on next host-admin tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_FOR_ZOOKEEPER_CLIENT_SERVER_COMMUNICATION = Flags.defineStringFlag("tls-for-zookeeper-client-server-communication", "OFF", List.of("hmusum"), "2020-12-02", "2021-02-01", "How to setup TLS for ZooKeeper client/server communication. Valid values are OFF, PORT_UNIFICATION, TLS_WITH_PORT_UNIFICATION, TLS_ONLY", "Takes effect on restart of config server", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_TLS_FOR_ZOOKEEPER_CLIENT = Flags.defineFeatureFlag("use-tls-for-zookeeper-client", false, List.of("hmusum"), "2020-12-02", "2021-02-01", "Whether to use TLS for ZooKeeper clients", "Takes effect on restart of process", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag VALIDATE_ENDPOINT_CERTIFICATES = Flags.defineFeatureFlag("validate-endpoint-certificates", false, List.of("andreer"), "2020-12-02", "2021-02-01", "Whether endpoint certificates should be validated before use", "Takes effect on the next deployment of the application", new FetchVector.Dimension[0]);
    public static final UnboundStringFlag DELETE_UNUSED_ENDPOINT_CERTIFICATES = Flags.defineStringFlag("delete-unused-endpoint-certificates", "disable", List.of("andreer"), "2020-12-02", "2021-02-01", "Whether the endpoint certificate maintainer should delete unused certificates in cameo/zk", "Takes effect on next scheduled run of maintainer - set to \"disable\", \"dryrun\" or \"enable\"", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag USE_ALTERNATIVE_ENDPOINT_CERTIFICATE_PROVIDER = Flags.defineFeatureFlag("use-alternative-endpoint-certificate-provider", false, List.of("andreer"), "2020-12-02", "2021-02-01", "Whether to use an alternative CA when provisioning new certificates", "Takes effect only on initial application deployment - not on later certificate refreshes!", new FetchVector.Dimension[0]);
    public static final UnboundStringFlag YUM_DIST_HOST = Flags.defineStringFlag("yum-dist-host", "", List.of("aressem"), "2020-12-02", "2021-02-01", "Override the default dist host for yum.", "Takes effect on next tick or on host-admin restart (may vary where used).", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag ENDPOINT_CERT_IN_SHARED_ROUTING = Flags.defineFeatureFlag("endpoint-cert-in-shared-routing", false, List.of("andreer"), "2020-12-02", "2021-02-01", "Whether to provision and use endpoint certs for apps in shared routing zones", "Takes effect on next deployment of the application", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag PROVISION_APPLICATION_ROLES = Flags.defineFeatureFlag("provision-application-roles", false, List.of("tokle"), "2020-12-02", "2021-02-01", "Whether application roles should be provisioned", "Takes effect on next deployment (controller)", FetchVector.Dimension.ZONE_ID);
    public static final UnboundBooleanFlag APPLICATION_IAM_ROLE = Flags.defineFeatureFlag("application-iam-roles", false, List.of("tokle"), "2020-12-02", "2021-02-01", "Allow separate iam roles when provisioning/assigning hosts", "Takes effect immediately on new hosts, on next redeploy for applications", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MAX_TRIAL_TENANTS = Flags.defineIntFlag("max-trial-tenants", -1, List.of("ogronnesby"), "2020-12-03", "2021-04-01", "The maximum nr. of tenants with trial plan, -1 is unlimited", "Takes effect immediately", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag CONTROLLER_PROVISION_LB = Flags.defineFeatureFlag("controller-provision-lb", false, List.of("mpolden"), "2020-12-02", "2021-02-01", "Provision load balancer for controller cluster", "Takes effect when controller application is redeployed", FetchVector.Dimension.ZONE_ID);
    public static final UnboundIntFlag TENANT_NODE_QUOTA = Flags.defineIntFlag("tenant-node-quota", 5, List.of("andreer"), "2020-12-02", "2021-02-01", "The number of nodes a tenant is allowed to request per cluster", "Only takes effect on next deployment, if set to a value other than the default for flag!", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ONLY_PUBLIC_ACCESS = Flags.defineFeatureFlag("enable-public-only", false, List.of("ogronnesby"), "2020-12-02", "2021-02-01", "Only access public hosts from container", "Takes effect on next tick", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag HIDE_SHARED_ROUTING_ENDPOINT = Flags.defineFeatureFlag("hide-shared-routing-endpoint", false, List.of("tokle"), "2020-12-02", "2021-02-01", "Whether the controller should hide shared routing layer endpoint", "Takes effect immediately", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ACCESS_CONTROL_CLIENT_AUTHENTICATION = Flags.defineFeatureFlag("use-access-control-client-authentication", false, List.of("tokle"), "2020-12-02", "2021-02-01", "Whether application container should set up client authentication on default port based on access control element", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", false, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Optionally deliver async messages in own thread", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag CONTENT_NODE_BUCKET_DB_STRIPE_BITS = Flags.defineIntFlag("content-node-bucket-db-stripe-bits", 0, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Number of bits used for striping the bucket DB in service layer", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundIntFlag MERGE_CHUNK_SIZE = Flags.defineIntFlag("merge-chunk-size", 0x400000, List.of("baldersheim"), "2020-12-02", "2021-02-01", "Size of baldersheim buffer in service layer", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag FEED_CONCURRENCY = Flags.defineDoubleFlag("feed-concurrency", 0.5, List.of("baldersheim"), "2020-12-02", "2021-02-01", "How much concurrency should be allowed for feed", "Takes effect at redeployment", FetchVector.Dimension.ZONE_ID, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_AUTOMATIC_REINDEXING = Flags.defineFeatureFlag("enable-automatic-reindexing", false, List.of("bjorncs", "jonmv"), "2020-12-02", "2021-02-01", "Whether to automatically trigger reindexing from config change", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_POWER_OF_TWO_CHOICES_LOAD_BALANCING = Flags.defineFeatureFlag("use-power-of-two-choices-load-balancing", false, List.of("tokle"), "2020-12-02", "2021-02-01", "Whether to use Power of two load balancing algorithm for application", "Takes effect on next internal redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag DYNAMIC_RECONFIGURATION_OF_ZOOKEEPER_CLUSTER = Flags.defineFeatureFlag("dynamic-reconfiguration-of-zookeeper-cluster", false, List.of("hmusum"), "2020-12-02", "2021-02-01", "Whether to allow dynamic reconfiguration of zookeeper cluster", "Takes effect on next deployment", FetchVector.Dimension.APPLICATION_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(FetchVector.Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

