/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundBooleanFlag USE_CONFIG_SERVER_CACHE = Flags.defineFeatureFlag("use-config-server-cache", true, "Whether config server will use cache to answer config requests.", "Takes effect immediately when changed.", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag CONFIG_SERVER_BOOTSTRAP_IN_SEPARATE_THREAD = Flags.defineFeatureFlag("config-server-bootstrap-in-separate-thread", false, "Whether to run config server/controller bootstrap in a separate thread.", "Takes effect only at bootstrap of config server/controller", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag MONITOR_TENANT_HOST_HEALTH = Flags.defineFeatureFlag("monitor-tenant-hosts-health", false, "Whether service monitor will monitor /state/v1/health of the host admins on the tenant hosts.", "Flag is read when config server starts", FetchVector.Dimension.HOSTNAME);
    public static final UnboundIntFlag DROP_CACHES = Flags.defineIntFlag("drop-caches", 3, "The int value to write into /proc/sys/vm/drop_caches for each tick. 1 is page cache, 2 is dentries inodes, 3 is both page cache and dentries inodes, etc.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_CROWDSTRIKE = Flags.defineFeatureFlag("enable-crowdstrike", true, "Whether to enable CrowdStrike.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_NESSUS = Flags.defineFeatureFlag("enable-nessus", true, "Whether to enable Nessus.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundListFlag<String> DISABLED_HOST_ADMIN_TASKS = Flags.defineListFlag("disabled-host-admin-tasks", Collections.emptyList(), "List of host-admin task names (as they appear in the log, e.g. root>main>UpgradeTask) that should be skipped", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE);
    public static final UnboundBooleanFlag USE_DEDICATED_NODE_FOR_LOGSERVER = Flags.defineFeatureFlag("use-dedicated-node-for-logserver", false, "Whether to use a dedicated node for the logserver.", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_DOCKER_91 = Flags.defineFeatureFlag("use-docker-91", false, "Whether to upgrade to Docker version 1.13.1-91.git07f3374", "Takes effect after restart of host admin", FetchVector.Dimension.HOSTNAME);
    public static final UnboundDoubleFlag CONTAINER_CPU_CAP = Flags.defineDoubleFlag("container-cpu-cap", 0.0, "Hard limit on how many CPUs a container may use. This value is multiplied by CPU allocated to node, so to cap CPU at 200%, set this to 2, etc.", "Takes effect on next node agent tick. Change is orchestrated, but does NOT require container restart", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag TLS_INSECURE_MIXED_MODE = Flags.defineStringFlag("tls-insecure-mixed-mode", "tls_client_mixed_server", "TLS insecure mixed mode. Allowed values: ['plaintext_client_mixed_server', 'tls_client_mixed_server', 'tls_client_tls_server']", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_INSECURE_AUTHORIZATION_MODE = Flags.defineStringFlag("tls-insecure-authorization-mode", "log_only", "TLS insecure authorization mode. Allowed values: ['disable', 'log_only', 'enforce']", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_FDISPATCH_BY_DEFAULT = Flags.defineFeatureFlag("use-fdispatch-by-default", true, "Should fdispatch be used as the default instead of the java dispatcher", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag USE_ADAPTIVE_DISPATCH = Flags.defineFeatureFlag("use-adaptive-dispatch", false, "Should adaptive dispatch be used over round robin", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_DYNAMIC_PROVISIONING = Flags.defineFeatureFlag("enable-dynamic-provisioning", false, "Provision a new docker host when we otherwise can't allocate a docker node", "Takes effect on next deployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_DISK_WRITE_TEST = Flags.defineFeatureFlag("enable-disk-write-test", false, "Regularly issue a small write to disk and fail the host if it is not successful", "Takes effect on next node agent tick (but does not clear existing failure reports)", FetchVector.Dimension.HOSTNAME);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundListFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    public static List<FlagDefinition> getAllFlags() {
        return new ArrayList<FlagDefinition>(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

