/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HostCapacity {
    @JsonProperty(value="vcpu")
    private final double vcpu;
    @JsonProperty(value="memoryGb")
    private final double memoryGb;
    @JsonProperty(value="diskGb")
    private final double diskGb;
    @JsonProperty(value="count")
    private final int count;

    public HostCapacity(@JsonProperty(value="vcpu") double vcpu, @JsonProperty(value="memoryGb") double memoryGb, @JsonProperty(value="diskGb") double diskGb, @JsonProperty(value="count") int count) {
        this.vcpu = HostCapacity.requirePositive("vcpu", vcpu);
        this.memoryGb = HostCapacity.requirePositive("memoryGb", memoryGb);
        this.diskGb = HostCapacity.requirePositive("diskGb", diskGb);
        this.count = (int)HostCapacity.requirePositive("count", count);
    }

    public double getVcpu() {
        return this.vcpu;
    }

    public double getMemoryGb() {
        return this.memoryGb;
    }

    public double getDiskGb() {
        return this.diskGb;
    }

    public int getCount() {
        return this.count;
    }

    private static double requirePositive(String name, double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostCapacity that = (HostCapacity)o;
        return Double.compare(that.vcpu, this.vcpu) == 0 && Double.compare(that.memoryGb, this.memoryGb) == 0 && Double.compare(that.diskGb, this.diskGb) == 0 && this.count == that.count;
    }

    public int hashCode() {
        return Objects.hash(this.vcpu, this.memoryGb, this.diskGb, this.count);
    }
}

