/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import com.yahoo.vespa.flags.custom.PreprovisionCapacity;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundIntFlag DROP_CACHES = Flags.defineIntFlag("drop-caches", 3, "The int value to write into /proc/sys/vm/drop_caches for each tick. 1 is page cache, 2 is dentries inodes, 3 is both page cache and dentries inodes, etc.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_CROWDSTRIKE = Flags.defineFeatureFlag("enable-crowdstrike", true, "Whether to enable CrowdStrike.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag ENABLE_NESSUS = Flags.defineFeatureFlag("enable-nessus", true, "Whether to enable Nessus.", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME);
    public static final UnboundListFlag<String> DISABLED_HOST_ADMIN_TASKS = Flags.defineListFlag("disabled-host-admin-tasks", List.of(), String.class, "List of host-admin task names (as they appear in the log, e.g. root>main>UpgradeTask) that should be skipped", "Takes effect on next host admin tick", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.NODE_TYPE);
    public static final UnboundStringFlag DOCKER_VERSION = Flags.defineStringFlag("docker-version", "1.13.1-91.git07f3374", "The version of the docker to use of the format VERSION-REL: The YUM package to be installed will be 2:docker-VERSION-REL.el7.centos.x86_64 in AWS (and without '.centos' otherwise). If docker-version is not of this format, it must be parseable by YumPackageName::fromString.", "Takes effect on next tick.", FetchVector.Dimension.HOSTNAME);
    public static final UnboundLongFlag THIN_POOL_GB = Flags.defineLongFlag("thin-pool-gb", -1L, "The size of the disk reserved for the thin pool with dynamic provisioning in AWS, in base-2 GB. If <0, the default is used (which may depend on the zone and node type).", "Takes effect immediately (but used only during provisioning).", FetchVector.Dimension.NODE_TYPE);
    public static final UnboundDoubleFlag CONTAINER_CPU_CAP = Flags.defineDoubleFlag("container-cpu-cap", 0.0, "Hard limit on how many CPUs a container may use. This value is multiplied by CPU allocated to node, so to cap CPU at 200%, set this to 2, etc.", "Takes effect on next node agent tick. Change is orchestrated, but does NOT require container restart", FetchVector.Dimension.HOSTNAME, FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag TLS_INSECURE_MIXED_MODE = Flags.defineStringFlag("tls-insecure-mixed-mode", "tls_client_mixed_server", "TLS insecure mixed mode. Allowed values: ['plaintext_client_mixed_server', 'tls_client_mixed_server', 'tls_client_tls_server']", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_INSECURE_AUTHORIZATION_MODE = Flags.defineStringFlag("tls-insecure-authorization-mode", "log_only", "TLS insecure authorization mode. Allowed values: ['disable', 'log_only', 'enforce']", "Takes effect on restart of Docker container", FetchVector.Dimension.NODE_TYPE, FetchVector.Dimension.APPLICATION_ID, FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_ADAPTIVE_DISPATCH = Flags.defineFeatureFlag("use-adaptive-dispatch", false, "Should adaptive dispatch be used over round robin", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag ENABLE_DYNAMIC_PROVISIONING = Flags.defineFeatureFlag("enable-dynamic-provisioning", false, "Provision a new docker host when we otherwise can't allocate a docker node", "Takes effect on next deployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundListFlag<PreprovisionCapacity> PREPROVISION_CAPACITY = Flags.defineListFlag("preprovision-capacity", List.of(), PreprovisionCapacity.class, "List of node resources and their count that should be present in zone to receive new deployments. When a preprovisioned is taken, new will be provisioned within next iteration of maintainer.", "Takes effect on next iteration of HostProvisionMaintainer.", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag USE_ADVERTISED_RESOURCES = Flags.defineFeatureFlag("use-advertised-resources", true, "When enabled, will use advertised host resources rather than actual host resources, ignore host resource reservation, and fail with exception unless requested resource match advertised host resources exactly.", "Takes effect on next iteration of HostProvisionMaintainer.", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundStringFlag CONFIGSERVER_RPC_AUTHORIZER = Flags.defineStringFlag("configserver-rpc-authorizer", "enforce", "Configserver RPC authorizer. Allowed values: ['disable', 'log-only', 'enforce']", "Takes effect on restart of configserver", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag PROVISION_APPLICATION_CERTIFICATE = Flags.defineFeatureFlag("provision-application-certificate", false, "Provision certificate from CA and include reference in deployment", "Takes effect on deployment through controller", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag DIRECT_ROUTING_USE_HTTPS_4443 = Flags.defineFeatureFlag("direct-routing-use-https-4443", false, "Decides whether NLB is pointed at container on port 4443 (https) or 4080 (http)", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag MULTIPLE_GLOBAL_ENDPOINTS = Flags.defineFeatureFlag("multiple-global-endpoints", false, "Allow applications to use new endpoints syntax in deployment.xml", "Takes effect on deployment through controller", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, "Node resource memory in Gb for admin cluster nodes", "Takes effect at redeployment", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag HOST_HARDENING = Flags.defineFeatureFlag("host-hardening", false, "Whether to enable host hardening Linux baseline.", "Takes effect on next tick or on host-admin restart (may vary where used).", FetchVector.Dimension.HOSTNAME);
    public static final UnboundBooleanFlag USE_INTERNAL_ZTS = Flags.defineFeatureFlag("use-internal-zts", false, "Decides if certificate in public should be requested from 'zts' configserver or mapped in", "Takes effect on next tick or on host-admin restart.", FetchVector.Dimension.APPLICATION_ID);
    public static final UnboundBooleanFlag DYNAMIC_UPSTREAM_CONNECTION_CACHE = Flags.defineFeatureFlag("dynamic-upstream-connection-cache", false, "Scale upstream connection cache with number of upstream servers", "Takes effect on routing container redeployment", new FetchVector.Dimension[0]);
    public static final UnboundBooleanFlag HEALTH_CHECK_ON_4081 = Flags.defineFeatureFlag("health-check-on-4081", false, "Change nginx to send health check requests on port 4081 instead of 4080.", "Takes effect on routing container redeployment", FetchVector.Dimension.APPLICATION_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundStringFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, String description, String modificationEffect, FetchVector.Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, String description, String modificationEffect, FetchVector.Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(FetchVector.Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting() {
        return new Replacer();
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer() {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }
}

