/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PreprovisionCapacity {
    @JsonProperty(value="vcpu")
    private final double vcpu;
    @JsonProperty(value="memoryGb")
    private final double memoryGb;
    @JsonProperty(value="diskGb")
    private final double diskGb;
    @JsonProperty(value="count")
    private final int count;

    public PreprovisionCapacity(@JsonProperty(value="vcpu") double vcpu, @JsonProperty(value="memoryGb") double memoryGb, @JsonProperty(value="diskGb") double diskGb, @JsonProperty(value="count") int count) {
        this.vcpu = PreprovisionCapacity.requirePositive("vcpu", vcpu);
        this.memoryGb = PreprovisionCapacity.requirePositive("memoryGb", memoryGb);
        this.diskGb = PreprovisionCapacity.requirePositive("diskGb", diskGb);
        this.count = (int)PreprovisionCapacity.requirePositive("count", count);
    }

    public double getVcpu() {
        return this.vcpu;
    }

    public double getMemoryGb() {
        return this.memoryGb;
    }

    public double getDiskGb() {
        return this.diskGb;
    }

    public int getCount() {
        return this.count;
    }

    private static double requirePositive(String name, double value) {
        if (value < 1.0) {
            throw new IllegalArgumentException("'" + name + "' must be positive, was " + value);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreprovisionCapacity that = (PreprovisionCapacity)o;
        return Double.compare(that.vcpu, this.vcpu) == 0 && Double.compare(that.memoryGb, this.memoryGb) == 0 && Double.compare(that.diskGb, this.diskGb) == 0 && this.count == that.count;
    }

    public int hashCode() {
        return Objects.hash(this.vcpu, this.memoryGb, this.diskGb, this.count);
    }
}

