/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;
import com.yahoo.vespa.flags.json.FlagData;
import com.yahoo.vespa.flags.json.Rule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;

public class FileFlagSource
implements FlagSource {
    private static final ObjectMapper mapper = new ObjectMapper();
    static final String FLAGS_DIRECTORY = "/etc/vespa/flags";
    private final Path flagsDirectory;

    @Inject
    public FileFlagSource() {
        this(FileSystems.getDefault());
    }

    public FileFlagSource(FileSystem fileSystem) {
        this(fileSystem.getPath(FLAGS_DIRECTORY, new String[0]));
    }

    public FileFlagSource(Path flagsDirectory) {
        this.flagsDirectory = flagsDirectory;
    }

    @Override
    public Optional<RawFlag> fetch(FlagId flagId, FetchVector vector) {
        return this.getResolver(flagId).resolve(vector);
    }

    private FlagData getResolver(FlagId flagId) {
        Optional<String> v2String = this.getString(flagId, ".2");
        if (v2String.isPresent()) {
            return FlagData.deserialize(v2String.get());
        }
        Optional<String> v1String = this.getString(flagId, "");
        if (v1String.isPresent()) {
            Rule rule = new Rule(Optional.of(JsonNodeRawFlag.fromJson(v1String.get())), Collections.emptyList());
            return new FlagData(flagId, new FetchVector(), Collections.singletonList(rule));
        }
        return new FlagData(flagId);
    }

    private Optional<String> getString(FlagId id, String suffix) {
        return this.getBytes(id, suffix).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    private Optional<byte[]> getBytes(FlagId id, String suffix) {
        try {
            return Optional.of(Files.readAllBytes(this.getPath(id, suffix)));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getPath(FlagId id, String suffix) {
        return this.flagsDirectory.resolve(id.toString() + suffix);
    }

    public String toString() {
        return "FileFlagSource{" + this.flagsDirectory + '}';
    }
}

