/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import java.util.function.Function;

public class StringFlag
implements Flag {
    private final FlagId id;
    private final String defaultValue;
    private final FlagSource source;

    public static Function<FlagSource, StringFlag> createUnbound(String flagId, String defaultValue) {
        return StringFlag.createUnbound(new FlagId(flagId), defaultValue);
    }

    public static Function<FlagSource, StringFlag> createUnbound(FlagId id, String defaultValue) {
        return source -> new StringFlag(id, defaultValue, (FlagSource)source);
    }

    public StringFlag(String flagId, String defaultValue, FlagSource source) {
        this(new FlagId(flagId), defaultValue, source);
    }

    public StringFlag(FlagId id, String defaultValue, FlagSource source) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.source = source;
    }

    @Override
    public FlagId id() {
        return this.id;
    }

    public String value() {
        return this.source.getString(this.id).orElse(this.defaultValue);
    }

    public String toString() {
        return "StringFlag{id=" + this.id + ", defaultValue='" + this.defaultValue + '\'' + ", source=" + this.source + '}';
    }
}

